/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.monitor;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.events.JavaMonitorInflateEvent;
import com.oracle.svm.core.monitor.JavaMonitor;
import com.oracle.svm.core.monitor.MonitorInflationCause;
import com.oracle.svm.core.monitor.MultiThreadedMonitorSupport;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.monitor.a;
import com.oracle.svm.enterprise.core.monitor.i;
import com.oracle.svm.enterprise.core.monitor.j;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SnippetAnchorNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.graal.compiler.word.BarrieredAccess;
import jdk.internal.misc.Unsafe;

public final class e
extends MultiThreadedMonitorSupport {
    @RestrictHeapAccess(reason="The monitor snippet slow path is uninterruptible to avoid stack overflow errors being thrown. Now the yellow zone is enabled and we are no longer uninterruptible, and allocation is allowed again too", access=RestrictHeapAccess.Access.UNRESTRICTED)
    public void monitorEnter(Object object, MonitorInflationCause monitorInflationCause) {
        if (BranchProbabilityNode.probability((double)0.010000000000000009, (!e.b(object, e.getMonitorOffset((Object)object), true) ? 1 : 0) != 0)) {
            JavaMonitor javaMonitor = this.getOrCreateMonitor(object, monitorInflationCause);
            javaMonitor.monitorEnter(object);
        }
    }

    @AlwaysInline(value="monitor fast path")
    static boolean b(Object object, int n2, boolean bl2) {
        if (BranchProbabilityNode.probability((double)0.99, (n2 != 0 ? 1 : 0) != 0)) {
            i i2;
            Object object2 = BarrieredAccess.readObject((Object)object, (int)n2);
            if (!((Boolean)j.UseThinLocking.getValue()).booleanValue()) {
                return e.h(object2);
            }
            i i3 = null;
            if (BranchProbabilityNode.probability((double)0.6, (object2 == null ? 1 : 0) != 0)) {
                i3 = i.a(bl2);
            } else if (BranchProbabilityNode.probability((double)0.6, (boolean)(object2 instanceof i)) && BranchProbabilityNode.probability((double)0.6, (boolean)(i2 = (i)object2).bw())) {
                i3 = i2.b(bl2);
            }
            if (BranchProbabilityNode.probability((double)0.99, (i3 != null ? 1 : 0) != 0)) {
                if (Unsafe.getUnsafe().compareAndSetReference(object, n2, object2, i3)) {
                    return true;
                }
            } else {
                return e.h(object2);
            }
        }
        return false;
    }

    @AlwaysInline(value="monitor fast path")
    private static boolean h(Object object) {
        if (BranchProbabilityNode.probability((double)0.99, (object != null ? 1 : 0) != 0)) {
            if (GraalDirectives.inIntrinsic()) {
                ReplacementsUtil.dynamicAssert((boolean)(object instanceof a), (String)"expecting inflated monitor");
            } else assert (object instanceof a);
            a a2 = (a)((Object)PiNode.piCast((Object)object, a.class, (boolean)false, (boolean)true, (GuardingNode)SnippetAnchorNode.anchor()));
            return a2.br();
        }
        return false;
    }

    @RestrictHeapAccess(reason="The monitor snippet slow path is uninterruptible to avoid stack overflow errors being thrown. Now the yellow zone is enabled and we are no longer uninterruptible, and allocation is allowed again too", access=RestrictHeapAccess.Access.UNRESTRICTED)
    public void monitorExit(Object object, MonitorInflationCause monitorInflationCause) {
        Object object2;
        if (!((Boolean)j.UseThinLocking.getValue()).booleanValue()) {
            JavaMonitor javaMonitor = this.getOrCreateMonitor(object, monitorInflationCause);
            javaMonitor.monitorExit();
            return;
        }
        Object object3 = e.replaceObject((Object)object);
        int n2 = -1;
        int n3 = e.getMonitorOffset((Object)object3);
        if (BranchProbabilityNode.probability((double)0.99, (n3 != 0 ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.99, (boolean)e.a(object3, n3, object2 = BarrieredAccess.readObject((Object)object3, (int)n3)))) {
            n2 = 0;
        }
        if (BranchProbabilityNode.probability((double)0.010000000000000009, (n2 != 0 ? 1 : 0) != 0)) {
            object2 = this.getOrCreateMonitor(object, monitorInflationCause);
            object2.monitorExit();
        }
    }

    @AlwaysInline(value="monitor fast path")
    static boolean a(Object object, int n2, Object object2) {
        if (((Boolean)j.UseThinLocking.getValue()).booleanValue() && BranchProbabilityNode.probability((double)0.6, (boolean)(object2 instanceof i))) {
            i i2 = ((i)object2).bz();
            if (Unsafe.getUnsafe().compareAndSetReference(object, n2, object2, i2)) {
                return true;
            }
        }
        return false;
    }

    @AlwaysInline(value="monitor fast path")
    static int i(Object object) {
        ReplacementsUtil.dynamicAssert((boolean)(object instanceof a), (String)"expecting inflated monitor");
        a a2 = (a)((Object)PiNode.piCast((Object)object, a.class, (boolean)false, (boolean)true, (GuardingNode)SnippetAnchorNode.anchor()));
        return a2.bs();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="Avoid stack overflow error before yellow zone has been activated", calleeMustBe=false)
    private static void slowPathMonitorExit(Object object, int n2) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            ((e)e.singleton()).b(object, n2);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw outOfMemoryError;
        }
        catch (Throwable throwable) {
            throw VMError.shouldNotReachHere((String)"Unexpected exception in MonitorSupport.monitorExit", (Throwable)throwable);
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    @RestrictHeapAccess(reason="The monitor snippet slow path is uninterruptible to avoid stack overflow errors being thrown. Now the yellow zone is enabled and we are no longer uninterruptible, and allocation is allowed again too", access=RestrictHeapAccess.Access.UNRESTRICTED)
    private void b(Object object, int n2) {
        if (n2 == 1) {
            Object object2 = BarrieredAccess.readObject((Object)object, (int)e.getMonitorOffset((Object)object));
            ((a)((Object)object2)).bt();
        } else if (n2 == -1) {
            this.monitorExit(object, MonitorInflationCause.VM_INTERNAL);
        } else {
            throw VMError.shouldNotReachHere((String)("Invalid status code from monitorexit fast-path: " + n2));
        }
    }

    private static i j(Object object) {
        Object object2;
        Object object3 = e.replaceObject((Object)object);
        int n2 = e.getMonitorOffset((Object)object3);
        if (n2 != 0 && (object2 = BarrieredAccess.readObject((Object)object3, (int)n2)) instanceof i) {
            return (i)object2;
        }
        return null;
    }

    public boolean isLockedByCurrentThread(Object object) {
        i i2 = e.j(object);
        if (i2 != null) {
            return i2.bw();
        }
        return super.isLockedByCurrentThread(object);
    }

    public boolean isLockedByAnyThread(Object object) {
        return e.j(object) != null || super.isLockedByAnyThread(object);
    }

    public void notify(Object object, boolean bl2) {
        i i2 = e.j(object);
        if (i2 != null) {
            if (!i2.bw()) {
                throw new IllegalMonitorStateException("Receiver is not locked by the current thread.");
            }
            return;
        }
        super.notify(object, bl2);
    }

    protected JavaMonitor getOrCreateMonitorFromObject(Object object, boolean bl2, int n2, MonitorInflationCause monitorInflationCause) {
        long l2;
        JavaMonitor javaMonitor;
        Object object2;
        do {
            if ((object2 = BarrieredAccess.readObject((Object)object, (int)n2)) instanceof JavaMonitor) {
                return (JavaMonitor)object2;
            }
            if (!bl2) {
                return null;
            }
            l2 = JfrTicks.elapsedTicks();
            if (object2 == null) {
                javaMonitor = this.newMonitorLock();
                continue;
            }
            i i2 = (i)object2;
            javaMonitor = a.a(i2);
        } while (!Unsafe.getUnsafe().compareAndSetReference(object, n2, object2, javaMonitor));
        JavaMonitorInflateEvent.emit((Object)object, (long)l2, (MonitorInflationCause)monitorInflationCause);
        return javaMonitor;
    }

    protected JavaMonitor newMonitorLock() {
        return new a();
    }
}

