/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.auximage;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointErrors;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImage;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageCodeObserver;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageProvider;
import com.oracle.svm.enterprise.core.auximage.d;
import com.oracle.svm.enterprise.core.auximage.f;
import com.oracle.svm.enterprise.core.auximage.r;
import com.oracle.svm.enterprise.core.auximage.s;
import java.io.File;
import java.util.concurrent.ThreadLocalRandom;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class AuxiliaryImageLoader {
    private static final CGlobalData<WordPointer> dM = CGlobalDataFactory.createWord((WordBase)AuxiliaryImageLoader.aN());
    private static Pointer dN;
    private static UnsignedWord dO;
    private static Pointer dP;
    private static Pointer dQ;
    private static volatile f dR;

    private static WordBase aN() {
        long l2;
        while ((l2 = ThreadLocalRandom.current().nextLong()) == 0L) {
        }
        return WordFactory.signed((long)l2);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static ComparableWord getPrimaryImageId() {
        return (ComparableWord)((WordPointer)dM.get()).read();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setAuxImageReservedSpace(Pointer pointer, UnsignedWord unsignedWord) {
        VMError.guarantee((dN.isNull() && dO.equal((UnsignedWord)WordFactory.zero()) ? 1 : 0) != 0);
        dN = pointer;
        dO = unsignedWord;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setAuxImageLocation(Pointer pointer, Pointer pointer2, UnsignedWord unsignedWord) {
        VMError.guarantee((pointer.isNull() == pointer2.isNull() && dP.isNull() == dQ.isNull() ? 1 : 0) != 0, (String)"sanity");
        VMError.guarantee((dP.isNull() || pointer.isNull() ? 1 : 0) != 0, (String)"Cannot replace a loaded image in-place");
        dP = pointer;
        dQ = pointer2;
        AuxiliaryImageLoader.b(unsignedWord);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void b(UnsignedWord unsignedWord) {
        Object object;
        f f2 = null;
        ImageHeapInfo imageHeapInfo = null;
        if (dP.isNonNull()) {
            object = KnownIntrinsics.heapBase().add(unsignedWord);
            f2 = (f)object.toObject();
            imageHeapInfo = f2.dW;
        }
        dR = f2;
        object = d.singleton();
        object.dG = imageHeapInfo;
        object.dH = true;
    }

    public static AuxiliaryImage load(File file) {
        b b2 = new b(file.getPath());
        b2.enqueue();
        if (b2.dU != null) {
            throw b2.dU;
        }
        AuxiliaryImageLoader.aR();
        return AuxiliaryImageLoader.getLoaded();
    }

    public static AuxiliaryImage getLoaded() {
        f f2 = dR;
        if (f2 == null) {
            throw new IllegalStateException("No auxiliary image has been loaded.");
        }
        return f2.dV;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static f aO() {
        return dR;
    }

    public static boolean hasLoaded() {
        return dR != null;
    }

    static void aP() {
        AuxiliaryImageLoader.aQ();
        AuxiliaryImageLoader.aR();
    }

    private static void aQ() {
        f f2 = dR;
        if (f2 != null) {
            if (r.isSupportedInCurrentImage()) {
                if (f2.dX.length > 0) {
                    a a2 = new a(f2);
                    a2.enqueue();
                }
            } else assert (f2.dX.length == 0) : "No runtime compilation, where does the compiled code come from?";
        }
    }

    private static void aR() {
        assert (!VMOperation.isInProgressAtSafepoint());
        f f2 = dR;
        if (f2 != null && r.isSupportedInCurrentImage() && f2.dX.length > 0) {
            for (AuxiliaryImageCodeObserver auxiliaryImageCodeObserver : f2.dZ) {
                auxiliaryImageCodeObserver.afterAllAuxiliaryImageCodeInstalled();
            }
        }
    }

    private AuxiliaryImageLoader() {
    }

    private static final class b
    extends JavaVMOperation {
        private final String dT;
        private RuntimeException dU;

        b(String string) {
            super(VMOperationInfos.get(b.class, (String)"Load auxiliary image", (VMOperation.SystemEffect)VMOperation.SystemEffect.SAFEPOINT));
            this.dT = string;
        }

        protected void operate() {
            try {
                this.aS();
            }
            catch (RuntimeException runtimeException) {
                this.dU = runtimeException;
            }
        }

        protected void aS() {
            if (dR != null) {
                throw new IllegalStateException("An auxiliary image is already loaded.");
            }
            if (dN.isNull() || dO.belowOrEqual(0)) {
                throw new IllegalStateException("No space was reserved for loading an auxiliary image during isolate creation");
            }
            WordPointer wordPointer = (WordPointer)UnsafeStackValue.get(WordPointer.class);
            WordPointer wordPointer2 = (WordPointer)UnsafeStackValue.get(WordPointer.class);
            try (CTypeConversion.CCharPointerHolder cCharPointerHolder = CTypeConversion.toCString((CharSequence)this.dT);){
                int n2 = AuxiliaryImageProvider.get().loadAuxiliaryImage(dN, dO, cCharPointerHolder.get(), wordPointer, wordPointer2);
                if (n2 != 0) {
                    throw new RuntimeException("Auxiliary image could not be loaded: " + CEntryPointErrors.getDescription((int)n2));
                }
                AuxiliaryImageLoader.aQ();
                d d2 = d.singleton();
                VMError.guarantee((dP.isNonNull() && dQ.isNonNull() && dR != null && d2.dG != null && d2.dH ? 1 : 0) != 0);
            }
        }
    }

    private static class a
    extends JavaVMOperation {
        private final f dS;

        a(f f2) {
            super(VMOperationInfos.get(a.class, (String)"Install auxiliary image persisted code", (VMOperation.SystemEffect)VMOperation.SystemEffect.SAFEPOINT));
            this.dS = f2;
        }

        protected void operate() {
            try {
                s.a(this.dS);
            }
            catch (Throwable throwable) {
                throw VMError.shouldNotReachHere((String)"Persisted code cache installation failed.", (Throwable)throwable);
            }
        }
    }
}

