/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.buildreport;

import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.buildreport.b;
import com.oracle.svm.enterprise.hosted.h;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class e
implements h.a {
    private final com.oracle.svm.enterprise.buildreport.a z;

    public e(com.oracle.svm.enterprise.buildreport.a a2) {
        this.z = a2;
    }

    @Override
    public List<Path> B() {
        return b.a.b(b.a.a.u);
    }

    @Override
    public void a(BuildArtifacts buildArtifacts) {
        List<Path> list = this.B();
        Path path = list.getFirst();
        b.a(path, this.z);
        BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.BUILD_INFO, path);
        for (Path path2 : list) {
            if (path2.equals(path)) continue;
            try {
                Path path3 = path2.getParent();
                if (path3 == null) {
                    throw VMError.shouldNotReachHere((String)"Build report path (%s) should always have a parent directory.", (Object[])new Object[]{path2.toString()});
                }
                Files.createDirectories(path3, new FileAttribute[0]);
                Files.copy(path, path2, new CopyOption[0]);
            }
            catch (IOException iOException) {
                throw VMError.shouldNotReachHere((String)"Failed to copy build report from '%s' to '%s'".formatted(path, path2), (Throwable)iOException);
            }
            BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.BUILD_INFO, path2);
        }
    }

    private static final class b {
        private static final String E = "/index.html";
        private static final String F = "/list-js.txt";
        private static final Pattern G = Pattern.compile("<!-- *@(.+) *-->");

        private b() {
        }

        private static String a(Path path) {
            return "/".concat(StreamSupport.stream(path.spliterator(), false).map(Path::toString).collect(Collectors.joining("/")));
        }

        private static byte[] e(String string) {
            try {
                InputStream inputStream = e.class.getResourceAsStream(string);
                assert (inputStream != null) : "Failed to access resource: " + string;
                return inputStream.readAllBytes();
            }
            catch (IOException iOException) {
                throw VMError.shouldNotReachHere((String)"Failed to read resource", (Throwable)iOException);
            }
        }

        private static void a(String string, Consumer<String> consumer) {
            try {
                InputStream inputStream = e.class.getResourceAsStream(string);
                assert (inputStream != null) : "Failed to access resource: " + string;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                    String string2;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        consumer.accept(string2);
                    }
                }
            }
            catch (IOException iOException) {
                throw VMError.shouldNotReachHere((String)"Failed to read resource", (Throwable)iOException);
            }
        }

        private static void a(a a2, BiConsumer<String, a> biConsumer) {
            b.a(E, (String string) -> {
                Matcher matcher = G.matcher(string.trim());
                if (matcher.find()) {
                    String string2 = matcher.group(1);
                    biConsumer.accept(string2, a2);
                } else {
                    a2.C.add((String)string);
                }
            });
        }

        private static void a(Path path, com.oracle.svm.enterprise.buildreport.a a2) {
            a a4 = new a(path);
            b.a(a4, (String string2, a a3) -> {
                Object[] objectArray = string2.split(" ");
                switch (objectArray[0]) {
                    case "INCLUDE_JS_FILES": {
                        String string3;
                        b.a(F, (String string) -> {
                            Path path = Path.of(string, new String[0]);
                            String string2 = b.a(path);
                            a3.d("<script>");
                            b.a(string2, a3::d);
                            a3.d("</script>");
                        });
                        try {
                            string3 = a2.b();
                        }
                        catch (IOException iOException) {
                            throw VMError.shouldNotReachHere((String)"Failed to dump build report data", (Throwable)iOException);
                        }
                        a3.d("<script>");
                        a3.d(string3);
                        a3.d("</script>");
                        break;
                    }
                    case "INCLUDE_CSS": {
                        assert (objectArray.length == 2) : "INCLUDE_CSS requires exactly one argument, found = " + Arrays.toString(objectArray);
                        String string4 = objectArray[1].trim();
                        String string5 = b.a(Path.of(E, new String[0]).resolveSibling(string4));
                        a3.d("<style>");
                        b.a(string5, a3::d);
                        a3.d("</style>");
                    }
                }
            });
            try {
                a4.C();
            }
            catch (IOException iOException) {
                throw VMError.shouldNotReachHere((String)"Failed to dump build report data", (Throwable)iOException);
            }
        }
    }

    private static final class a {
        private static final boolean A = true;
        private final Path B;
        private final List<String> C = new ArrayList<String>();
        private final Map<String, byte[]> D = new HashMap<String, byte[]>();

        a(Path path) {
            this.B = path;
        }

        void d(String string) {
            this.C.add(string);
        }

        void a(String string, byte[] byArray) {
            assert (!string.startsWith("/")) : "Resource path should be relative to target directory, found = " + string;
            this.D.put(string, byArray);
        }

        void C() throws IOException {
            Path path = this.B.getParent();
            if (path == null) {
                throw VMError.shouldNotReachHere((String)"Build report path (%s) should always have a parent directory.", (Object[])new Object[]{this.B.toString()});
            }
            Files.createDirectories(path, new FileAttribute[0]);
            try (PrintWriter printWriter = new PrintWriter(this.B.toFile());){
                for (String string2 : this.C) {
                    printWriter.println(string2);
                }
            }
            assert (this.D.isEmpty()) : "EMBED_RESOURCE = true, resources.size = " + this.D.size();
            this.D.forEach((string, byArray) -> {
                Path path2 = path.resolve((String)string);
                try {
                    Files.write(path2, byArray, new OpenOption[0]);
                }
                catch (IOException iOException) {
                    throw VMError.shouldNotReachHere((String)"Failed write build report", (Throwable)iOException);
                }
            });
        }
    }
}

