/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config.conditional;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.conditional.MethodCallNode;
import com.oracle.svm.configure.config.conditional.MethodInfo;
import com.oracle.svm.configure.config.conditional.MethodInfoRepository;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationParser;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import jdk.graal.compiler.util.json.JsonParserException;
import jdk.graal.compiler.util.json.JsonPrintable;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public class PartialConfigurationWithOrigins
extends ConfigurationParser
implements JsonPrintable {
    private static final ConfigurationSet emptyConfigurationSet = new ConfigurationSet();
    private final MethodCallNode root;
    private final MethodInfoRepository methodInfoRegistry;

    public PartialConfigurationWithOrigins(MethodCallNode root, MethodInfoRepository methodInfoRegistry) {
        super(true);
        this.root = root;
        this.methodInfoRegistry = methodInfoRegistry;
    }

    public void printJson(JsonWriter writer) throws IOException {
        writer.append("{").indent().newline().quote("configuration-with-origins").append(": ");
        this.printJson(this.root, writer);
        writer.unindent().newline();
        writer.append("}").newline();
    }

    private void printJson(MethodCallNode node, JsonWriter writer) throws IOException {
        ConfigurationSet configSet;
        writer.append("{").indent().newline();
        String className = node.methodInfo != null ? node.methodInfo.getJavaDeclaringClassName() : "<root>";
        String methodName = node.methodInfo != null ? node.methodInfo.getName() : "<root>";
        String signature = node.methodInfo != null ? node.methodInfo.getSignature() : "()V";
        writer.quote("class").append(": ").quote(className).append(",").newline();
        writer.quote("method").append(": ").quote(methodName).append(",").newline();
        writer.quote("signature").append(": ").quote(signature).append(",").newline();
        writer.quote("methods").append(": [");
        boolean first = true;
        for (MethodCallNode methodCallNode : node.calledMethods.values()) {
            if (first) {
                first = false;
            } else {
                writer.append(",");
            }
            writer.newline();
            this.printJson(methodCallNode, writer);
        }
        writer.newline().append("]");
        ConfigurationSet configurationSet = configSet = node.configuration == null ? emptyConfigurationSet : node.configuration;
        if (!configSet.isEmpty()) {
            writer.append(",").newline();
        }
        PartialConfigurationWithOrigins.printConfigurationSet(writer, configSet);
        writer.unindent().newline();
        writer.append("}");
    }

    public void parseAndRegister(Object json, URI origin) throws IOException {
        EconomicMap topObject = PartialConfigurationWithOrigins.asMap((Object)json, (String)"Top level of document must be an object");
        Object originsObject = topObject.get((Object)"configuration-with-origins");
        if (originsObject == null) {
            throw new JsonParserException("Top level object must have a 'configuration-with-origins' property.");
        }
        EconomicMap rootMethod = PartialConfigurationWithOrigins.asMap((Object)originsObject, (String)"'configuration-with-origins' must be an object");
        this.parseMethodEntry(null, rootMethod, origin);
    }

    private static String getStringProperty(EconomicMap<String, ?> json, String property) {
        Object prop = json.get((Object)property);
        if (prop == null) {
            throw new JsonParserException("Missing property '" + property + "'");
        }
        return PartialConfigurationWithOrigins.asString((Object)prop);
    }

    private void parseMethodEntry(MethodCallNode parent, EconomicMap<String, ?> methodJson, URI origin) throws IOException {
        MethodCallNode target;
        if (parent == null) {
            target = this.root;
        } else {
            String className = PartialConfigurationWithOrigins.getStringProperty(methodJson, "class");
            String methodName = PartialConfigurationWithOrigins.getStringProperty(methodJson, "method");
            String signature = PartialConfigurationWithOrigins.getStringProperty(methodJson, "signature");
            MethodInfo info = this.methodInfoRegistry.getOrAdd(className, methodName, signature);
            target = parent.getOrCreateChild(info);
        }
        Object config = methodJson.get((Object)"config");
        if (config != null) {
            EconomicMap configJson = PartialConfigurationWithOrigins.asMap((Object)config, (String)"'config' must be an object");
            PartialConfigurationWithOrigins.parseConfigurationSet(configJson, target.getConfiguration(), origin);
        }
        Object methods = methodJson.get((Object)"methods");
        List methodsList = PartialConfigurationWithOrigins.asList((Object)methods, (String)"'methods' must be a list");
        for (Object methodObject : methodsList) {
            EconomicMap method = PartialConfigurationWithOrigins.asMap(methodObject, (String)"'methods' must contain objects");
            this.parseMethodEntry(target, method, origin);
        }
    }

    private static void printConfigurationSet(JsonWriter writer, ConfigurationSet configurationSet) throws IOException {
        if (!configurationSet.isEmpty()) {
            Object config;
            writer.quote("config").appendFieldSeparator().appendObjectStart();
            writer.quote(ConfigurationFile.REACHABILITY_METADATA.getName()).appendFieldSeparator().appendObjectStart();
            boolean first = true;
            for (ConfigurationFile file : ConfigurationFile.agentGeneratedFiles()) {
                config = configurationSet.getConfiguration(file);
                if (((ConfigurationBase)config).isEmpty() || !((ConfigurationBase)config).supportsCombinedFile()) continue;
                if (first) {
                    first = false;
                } else {
                    writer.appendSeparator();
                }
                ConfigurationSet.printConfigurationToCombinedFile(config, file, writer);
            }
            writer.appendObjectEnd();
            for (ConfigurationFile file : ConfigurationFile.agentGeneratedFiles()) {
                config = configurationSet.getConfiguration(file);
                if (((ConfigurationBase)config).isEmpty() || ((ConfigurationBase)config).supportsCombinedFile()) continue;
                writer.appendSeparator();
                writer.quote(file.getName()).appendFieldSeparator();
                ((ConfigurationBase)config).printLegacyJson(writer);
            }
            writer.appendObjectEnd();
        }
    }

    private static void parseConfigurationSet(EconomicMap<String, ?> configJson, ConfigurationSet configurationSet, URI origin) throws IOException {
        MapCursor cursor = configJson.getEntries();
        while (cursor.advance()) {
            String configName = (String)cursor.getKey();
            ConfigurationFile configType = ConfigurationFile.getByName((String)configName);
            if (configType == null) {
                throw new JsonParserException("Invalid configuration type: " + configName);
            }
            if (configType == ConfigurationFile.REACHABILITY_METADATA) {
                for (ConfigurationFile file : ConfigurationFile.combinedFileConfigurations()) {
                    ((ConfigurationBase)configurationSet.getConfiguration(file)).createParser(true).parseAndRegister(cursor.getValue(), origin);
                }
                continue;
            }
            ((ConfigurationBase)configurationSet.getConfiguration(configType)).createParser(false).parseAndRegister(cursor.getValue(), origin);
        }
    }
}

