/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.foreign;

import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.hosted.foreign.FunctionDescriptorParser;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import jdk.graal.compiler.util.json.JsonParserException;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeForeignAccessSupport;

@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+27/src/java.base/share/classes/jdk/internal/foreign/abi/LinkerOptions.java")
@Platforms(value={Platform.HOSTED_ONLY.class})
public class ForeignFunctionsConfigurationParser
extends ConfigurationParser {
    private static final String DOWNCALL_OPTION_CAPTURE_CALL_STATE = "captureCallState";
    private static final String DOWNCALL_OPTION_FIRST_VARIADIC_ARG = "firstVariadicArg";
    private static final String DOWNCALL_OPTION_CRITICAL = "critical";
    private static final String DOWNCALL_OPTION_ALLOW_HEAP_ACCESS = "allowHeapAccess";
    private final RuntimeForeignAccessSupport accessSupport;

    public ForeignFunctionsConfigurationParser(RuntimeForeignAccessSupport access) {
        super(true);
        this.accessSupport = access;
    }

    public void parseAndRegister(Object json, URI origin) {
        EconomicMap topLevel = ForeignFunctionsConfigurationParser.asMap((Object)json, (String)"first level of document must be a map");
        this.checkAttributes(topLevel, "foreign methods categories", List.of(), List.of("downcalls", "upcalls"));
        List downcalls = ForeignFunctionsConfigurationParser.asList((Object)topLevel.get((Object)"downcalls", List.of()), (String)"downcalls must be an array of method signatures");
        for (Object downcall : downcalls) {
            this.parseAndRegisterForeignCall(downcall, this::parseDowncallOptions, (descriptor, options) -> this.accessSupport.registerForDowncall(ConfigurationCondition.alwaysTrue(), descriptor, options));
        }
        List upcalls = ForeignFunctionsConfigurationParser.asList((Object)topLevel.get((Object)"upcalls", List.of()), (String)"upcalls must be an array of method signatures");
        for (Object upcall : upcalls) {
            this.parseAndRegisterForeignCall(upcall, this::parseUpcallOptions, (descriptor, options) -> this.accessSupport.registerForUpcall(ConfigurationCondition.alwaysTrue(), descriptor, options));
        }
    }

    private void parseAndRegisterForeignCall(Object call, Function<EconomicMap<String, Object>, List<Linker.Option>> optionsParser, BiConsumer<Object, Object[]> register) {
        EconomicMap map = ForeignFunctionsConfigurationParser.asMap((Object)call, (String)"a foreign call must be a map");
        this.checkAttributes(map, "foreign call", List.of("descriptor"), List.of("options"));
        FunctionDescriptor descriptor = this.parseDescriptor(map.get((Object)"descriptor"));
        Object options = map.get((Object)"options", (Object)EconomicMap.create());
        List<Linker.Option> parsedOptions = optionsParser.apply((EconomicMap<String, Object>)ForeignFunctionsConfigurationParser.asMap((Object)options, (String)"options must be a map"));
        register.accept(descriptor, parsedOptions.toArray());
    }

    private FunctionDescriptor parseDescriptor(Object signature) {
        String input = ForeignFunctionsConfigurationParser.asString((Object)signature, (String)"a function descriptor must be a string");
        return FunctionDescriptorParser.parse(input);
    }

    private List<Linker.Option> parseDowncallOptions(EconomicMap<String, Object> map) {
        this.checkAttributes(map, "options", List.of(), List.of(DOWNCALL_OPTION_FIRST_VARIADIC_ARG, DOWNCALL_OPTION_CAPTURE_CALL_STATE, DOWNCALL_OPTION_CRITICAL));
        ArrayList<Linker.Option> res = new ArrayList<Linker.Option>();
        if (map.containsKey((Object)DOWNCALL_OPTION_FIRST_VARIADIC_ARG)) {
            int firstVariadic = (int)ForeignFunctionsConfigurationParser.asLong((Object)map.get((Object)DOWNCALL_OPTION_FIRST_VARIADIC_ARG), (String)"");
            res.add(Linker.Option.firstVariadicArg(firstVariadic));
        }
        if (map.containsKey((Object)DOWNCALL_OPTION_CAPTURE_CALL_STATE) && ForeignFunctionsConfigurationParser.asBoolean((Object)map.get((Object)DOWNCALL_OPTION_CAPTURE_CALL_STATE, (Object)""), (String)DOWNCALL_OPTION_CAPTURE_CALL_STATE)) {
            res.add(Linker.Option.captureCallState("errno"));
        }
        if (map.containsKey((Object)DOWNCALL_OPTION_CRITICAL)) {
            Object criticalOpt = map.get((Object)DOWNCALL_OPTION_CRITICAL, (Object)"");
            if (criticalOpt instanceof Boolean) {
                Boolean b = (Boolean)criticalOpt;
                if (b.booleanValue()) {
                    res.add(Linker.Option.critical((boolean)false));
                }
            } else if (criticalOpt instanceof EconomicMap) {
                EconomicMap criticalMap = (EconomicMap)criticalOpt;
                this.checkAttributes(criticalMap, DOWNCALL_OPTION_CRITICAL, List.of(), List.of(DOWNCALL_OPTION_ALLOW_HEAP_ACCESS));
                boolean allowHeapAccess = false;
                if (criticalMap.containsKey((Object)DOWNCALL_OPTION_ALLOW_HEAP_ACCESS)) {
                    allowHeapAccess = ForeignFunctionsConfigurationParser.asBoolean((Object)criticalMap.get((Object)DOWNCALL_OPTION_ALLOW_HEAP_ACCESS), (String)DOWNCALL_OPTION_ALLOW_HEAP_ACCESS);
                }
                res.add(Linker.Option.critical((boolean)allowHeapAccess));
            } else {
                throw new JsonParserException("allowHeapAccess should be a boolean or a map");
            }
        }
        return res;
    }

    private List<Linker.Option> parseUpcallOptions(EconomicMap<String, Object> map) {
        this.checkAttributes(map, "options", List.of(), List.of());
        return List.of();
    }
}

