/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.foreign.ForeignFunctionsEnabled;
import com.oracle.svm.core.foreign.ForeignFunctionsRuntime;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import jdk.internal.foreign.MemorySessionImpl;

@TargetClass(className="jdk.internal.foreign.abi.UpcallStubs", onlyWith={ForeignFunctionsEnabled.class})
final class Target_jdk_internal_foreign_abi_UpcallStubs {
    Target_jdk_internal_foreign_abi_UpcallStubs() {
    }

    @Substitute
    static MemorySegment makeUpcall(final long entry, Arena arena) {
        MemorySessionImpl.toMemorySession(arena).addOrCleanupIfFail(new MemorySessionImpl.ResourceList.ResourceCleanup(){

            @Override
            public void cleanup() {
                ForeignFunctionsRuntime.singleton().freeTrampoline(entry);
            }
        });
        return MemorySegment.ofAddress(entry).reinterpret(arena, null);
    }
}

