/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class LightImmutableCollection {
    private LightImmutableCollection() {
    }

    public static <U> int size(U holder, AtomicReferenceFieldUpdater<U, Object> updater) {
        Object value = updater.get(holder);
        if (value == null) {
            return 0;
        }
        if (value instanceof Object[]) {
            return ((Object[])value).length;
        }
        return 1;
    }

    public static <T> boolean isEmpty(T holder, AtomicReferenceFieldUpdater<T, Object> updater) {
        Object value = updater.get(holder);
        return value == null;
    }

    public static <T, U> void forEach(U holder, AtomicReferenceFieldUpdater<U, Object> updater, Consumer<? super T> action) {
        Object value = updater.get(holder);
        if (value == null) {
            return;
        }
        if (value instanceof Object[]) {
            for (Object element : (Object[])value) {
                action.accept(element);
            }
        } else {
            action.accept(value);
        }
    }

    public static <T, U> boolean allMatch(U holder, AtomicReferenceFieldUpdater<U, Object> updater, Predicate<? super T> predicate) {
        Object value = updater.get(holder);
        if (value == null) {
            return true;
        }
        if (value instanceof Object[]) {
            for (Object element : (Object[])value) {
                if (predicate.test(element)) continue;
                return false;
            }
            return true;
        }
        return predicate.test(value);
    }

    public static <T, U> T toSingleElement(U holder, AtomicReferenceFieldUpdater<U, Object> updater) {
        Object value = updater.get(holder);
        if (value == null || value instanceof Object[]) {
            return null;
        }
        return (T)value;
    }

    public static <T, U> Collection<T> toCollection(U holder, AtomicReferenceFieldUpdater<U, Object> updater) {
        Object value = updater.get(holder);
        if (value == null) {
            return Collections.emptySet();
        }
        if (value instanceof Object[]) {
            return List.of((Object[])value);
        }
        return Collections.singleton(value);
    }

    public static <T, U> void initializeNonEmpty(U holder, AtomicReferenceFieldUpdater<U, Object> updater, T element) {
        assert (element != null && !(element instanceof Object[])) : element;
        updater.set(holder, element);
    }

    public static <T, U> void initializeNonEmpty(U holder, AtomicReferenceFieldUpdater<U, Object> updater, Collection<T> value) {
        assert (value != null && value.size() != 0) : value;
        if (value.size() == 1) {
            T element = value.iterator().next();
            assert (element != null && !(element instanceof Object[])) : element;
            updater.set(holder, element);
        } else {
            updater.set(holder, value.toArray());
        }
    }
}

