/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.object;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.flow.context.object.ContextSensitiveAnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;

public class AllocationContextSensitiveObject
extends ContextSensitiveAnalysisObject {
    protected final BytecodePosition allocationLabel;
    protected final AnalysisContext allocationContext;

    public AllocationContextSensitiveObject(PointsToAnalysis bb, AnalysisType type, BytecodePosition allocationSite, AnalysisContext context) {
        super(bb.getUniverse(), type, AnalysisObject.AnalysisObjectKind.AllocationContextSensitive);
        assert (bb.trackConcreteAnalysisObjects(type)) : type;
        this.allocationLabel = allocationSite;
        this.allocationContext = context;
        assert (allocationSite != null);
    }

    public BytecodePosition allocationLabel() {
        return this.allocationLabel;
    }

    public AnalysisContext allocationContext() {
        return this.allocationContext;
    }

    @Override
    public ArrayElementsTypeFlow getArrayElementsFlow(PointsToAnalysis bb, boolean isStore) {
        assert (this.type.isArray()) : this.type;
        assert (bb.analysisPolicy().allocationSiteSensitiveHeap()) : "policy mismatch";
        if (!this.arrayElementsTypeStore.writeFlow().getState().canBeNull()) {
            this.arrayElementsTypeStore.writeFlow().addState(bb, TypeState.forNull());
        }
        return isStore ? this.arrayElementsTypeStore.writeFlow() : this.arrayElementsTypeStore.readFlow();
    }

    @Override
    public String toString() {
        return super.toString() + "  " + String.valueOf(this.allocationLabel) + "  " + String.valueOf(this.allocationContext);
    }
}

