/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect.proxy;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.reflect.proxy.ProxyRenamingSubstitutionProcessor;
import com.oracle.svm.hosted.reflect.proxy.ProxySubstitutionType;
import java.util.HashSet;
import java.util.List;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class StableProxyNameFeature
implements InternalFeature {
    StableProxyNameFeature() {
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        assert (StableProxyNameFeature.checkProxyNames(((FeatureImpl.AfterAnalysisAccessImpl)access).getUniverse().getTypes()));
    }

    private static boolean checkProxyNames(List<AnalysisType> types) {
        if (!SubstrateUtil.assertionsEnabled()) {
            throw new AssertionError((Object)"Expensive check: should only run with assertions enabled.");
        }
        if (types.stream().anyMatch(type -> ProxyRenamingSubstitutionProcessor.isProxyType((ResolvedJavaType)type) && type.getWrapped().getClass() != ProxySubstitutionType.class)) {
            throw new AssertionError((Object)"All proxies should be substituted.");
        }
        HashSet proxyNames = new HashSet();
        types.stream().filter(ProxyRenamingSubstitutionProcessor::isProxyType).map(AnalysisType::getName).forEach(name -> {
            if (proxyNames.contains(name)) {
                throw new AssertionError((Object)("Duplicate proxy name: " + name));
            }
            proxyNames.add(name);
        });
        return true;
    }
}

