/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.core.reflect.SubstrateMethodAccessor;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.reflect.ReflectionFeature;
import org.graalvm.nativeimage.ImageSingletons;

final class ComputeVTableOffset
implements FieldValueTransformerWithAvailability {
    ComputeVTableOffset() {
    }

    @Override
    public boolean isAvailable() {
        return BuildPhaseProvider.isHostedUniverseBuilt();
    }

    public Object transform(Object receiver, Object originalValue) {
        SubstrateMethodAccessor accessor = (SubstrateMethodAccessor)receiver;
        if (accessor.getVTableOffset() == -559087615) {
            HostedMethod member = ((ReflectionFeature)ImageSingletons.lookup(ReflectionFeature.class)).hostedMetaAccess().lookupJavaMethod(accessor.getMember());
            if (SubstrateOptions.useClosedTypeWorldHubLayout()) {
                return KnownOffsets.singleton().getVTableOffset(member.getVTableIndex(), true);
            }
            return KnownOffsets.singleton().getVTableOffset(member.getVTableIndex(), false);
        }
        VMError.guarantee(accessor.getVTableOffset() == -1);
        return accessor.getVTableOffset();
    }
}

