/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.nodes;

import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.LimitedValueProxy;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class DeoptProxyNode
extends FloatingNode
implements LimitedValueProxy,
Node.ValueNumberable,
LIRLowerable,
Canonicalizable,
IterableNodeType {
    public static final NodeClass<DeoptProxyNode> TYPE = NodeClass.create(DeoptProxyNode.class);
    @Node.Input(value=InputType.Anchor)
    protected ValueNode proxyPoint;
    @Node.Input
    protected ValueNode value;
    protected final int deoptIndex;

    protected DeoptProxyNode(ValueNode value, ValueNode proxyPoint, int deoptIndex) {
        super(TYPE, value.stamp(NodeView.DEFAULT));
        this.value = value;
        this.proxyPoint = proxyPoint;
        this.deoptIndex = deoptIndex;
    }

    public static ValueNode create(ValueNode value, ValueNode proxyPoint, int deoptIndex) {
        ValueNode synonym = DeoptProxyNode.findSynonym(value);
        if (synonym != null) {
            return synonym;
        }
        return new DeoptProxyNode(value, proxyPoint, deoptIndex);
    }

    public boolean inferStamp() {
        return this.updateStamp(this.value.stamp(NodeView.DEFAULT));
    }

    public ValueNode getOriginalNode() {
        return this.value;
    }

    public void generate(NodeLIRBuilderTool gen) {
        gen.setResult((ValueNode)this, gen.operand((Node)this.value));
    }

    public Node canonical(CanonicalizerTool tool) {
        ValueNode synonym = DeoptProxyNode.findSynonym(this.value);
        return synonym != null ? synonym : this;
    }

    private static ValueNode findSynonym(ValueNode value) {
        return value.isConstant() ? value : null;
    }

    public boolean hasProxyPoint() {
        return this.proxyPoint != null;
    }

    public ValueNode getProxyPoint() {
        return this.proxyPoint;
    }
}

