/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.imagelayer.BuildingImageLayerPredicate;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.UnsavedSingleton;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticallyRegisteredImageSingleton(onlyWith={BuildingImageLayerPredicate.class})
public class LayeredImageHeapObjectAdder
implements UnsavedSingleton {
    private final Set<BiConsumer<NativeImageHeap, HostedUniverse>> objectAdders = new HashSet<BiConsumer<NativeImageHeap, HostedUniverse>>();
    private boolean sealed = false;

    public static LayeredImageHeapObjectAdder singleton() {
        return (LayeredImageHeapObjectAdder)ImageSingletons.lookup(LayeredImageHeapObjectAdder.class);
    }

    public void registerObjectAdder(BiConsumer<NativeImageHeap, HostedUniverse> adder) {
        VMError.guarantee(!this.sealed, "Object adder is registered too late");
        this.objectAdders.add(adder);
    }

    public void addInitialObjects(NativeImageHeap heap, HostedUniverse hUniverse) {
        this.sealed = true;
        this.objectAdders.forEach(adder -> adder.accept(heap, hUniverse));
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }
}

