/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.svm.core.SubstrateOptions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.FullInfopointNode;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.extended.ValueAnchorNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.spi.ValueProxy;
import jdk.graal.compiler.replacements.nodes.MethodHandleWithExceptionNode;

public class InliningUtilities {
    public static boolean isTrivialMethod(StructuredGraph graph) {
        int numInvokes = 0;
        int numOthers = 0;
        for (Node n : graph.getNodes()) {
            if (n instanceof StartNode || n instanceof ParameterNode || n instanceof FullInfopointNode || n instanceof ValueProxy || n instanceof ValueAnchorNode || n instanceof FrameState) continue;
            if (n instanceof MethodCallTargetNode || n instanceof MethodHandleWithExceptionNode) {
                ++numInvokes;
            } else {
                ++numOthers;
            }
            if (InliningUtilities.shouldBeTrivial(numInvokes, numOthers, graph)) continue;
            return false;
        }
        return true;
    }

    private static boolean shouldBeTrivial(int numInvokes, int numOthers, StructuredGraph graph) {
        if (numInvokes == 0) {
            return numOthers <= (Integer)SubstrateOptions.MaxNodesInTrivialLeafMethod.getValue(graph.getOptions());
        }
        if (numInvokes <= (Integer)SubstrateOptions.MaxInvokesInTrivialMethod.getValue(graph.getOptions())) {
            return numOthers <= (Integer)SubstrateOptions.MaxNodesInTrivialMethod.getValue(graph.getOptions());
        }
        return false;
    }
}

