/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.jdk.SystemInOutErrSupport;
import com.oracle.svm.core.layeredimagesingleton.FeatureSingleton;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageSystemIOWrappers;
import com.oracle.svm.hosted.imagelayer.CrossLayerConstantRegistry;
import com.oracle.svm.util.ReflectionUtil;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import jdk.internal.access.SharedSecrets;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class SystemInOutErrFeature
implements InternalFeature,
FeatureSingleton {
    private final InputStream hostedIn = System.in;
    private final PrintStream hostedOut;
    private final PrintStream hostedErr;
    private final InputStream hostedInitialIn;
    private final PrintStream hostedInitialErr;
    private SystemInOutErrSupport runtime;
    private static final String SYSTEM_IN_KEY_NAME = "System#in";
    private static final String SYSTEM_ERR_KEY_NAME = "System#err";
    private static final String SYSTEM_OUT_KEY_NAME = "System#out";
    private static final String SYSTEM_INITIAL_IN_KEY_NAME = "System#initialIn";
    private static final String SYSTEM_INITIAL_ERR_KEY_NAME = "System#initialErr";

    public SystemInOutErrFeature() {
        NativeImageSystemIOWrappers wrappers = NativeImageSystemIOWrappers.singleton();
        this.hostedOut = wrappers.outWrapper;
        this.hostedErr = wrappers.errWrapper;
        this.hostedInitialIn = SharedSecrets.getJavaLangAccess().initialSystemIn();
        Field initialErrField = ReflectionUtil.lookupField((boolean)true, System.class, (String)"initialErr");
        try {
            this.hostedInitialErr = initialErrField != null ? (PrintStream)initialErrField.get(null) : null;
        }
        catch (IllegalAccessException illegalAccess) {
            throw VMError.shouldNotReachHere(illegalAccess);
        }
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (ImageLayerBuildingSupport.firstImageBuild()) {
            this.runtime = new SystemInOutErrSupport();
            ImageSingletons.add(SystemInOutErrSupport.class, (Object)this.runtime);
        }
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        NativeImageSystemIOWrappers.singleton().verifySystemOutErrReplacement();
        if (ImageLayerBuildingSupport.firstImageBuild()) {
            if (ImageLayerBuildingSupport.buildingInitialLayer()) {
                CrossLayerConstantRegistry registry = CrossLayerConstantRegistry.singletonOrNull();
                registry.registerHeapConstant(SYSTEM_IN_KEY_NAME, this.runtime.in());
                registry.registerHeapConstant(SYSTEM_OUT_KEY_NAME, this.runtime.out());
                registry.registerHeapConstant(SYSTEM_ERR_KEY_NAME, this.runtime.err());
                registry.registerHeapConstant(SYSTEM_INITIAL_IN_KEY_NAME, this.runtime.initialIn());
                registry.registerHeapConstant(SYSTEM_INITIAL_ERR_KEY_NAME, this.runtime.initialErr());
            }
            access.registerObjectReplacer(this::replaceStreamsWithRuntimeObject);
        } else {
            CrossLayerConstantRegistry registry = CrossLayerConstantRegistry.singletonOrNull();
            ((FeatureImpl.DuringSetupAccessImpl)access).registerObjectToConstantReplacer(obj -> this.replaceStreamsWithLayerConstant(registry, obj));
        }
    }

    public void cleanup() {
        NativeImageSystemIOWrappers.singleton().verifySystemOutErrReplacement();
    }

    Object replaceStreamsWithRuntimeObject(Object object) {
        if (object == this.hostedIn) {
            return this.runtime.in();
        }
        if (object == this.hostedOut) {
            return this.runtime.out();
        }
        if (object == this.hostedErr) {
            return this.runtime.err();
        }
        if (object == this.hostedInitialErr) {
            return this.runtime.initialErr();
        }
        if (object == this.hostedInitialIn) {
            return this.runtime.initialIn();
        }
        return object;
    }

    ImageHeapConstant replaceStreamsWithLayerConstant(CrossLayerConstantRegistry registry, Object object) {
        if (object == this.hostedIn) {
            return registry.getConstant(SYSTEM_IN_KEY_NAME);
        }
        if (object == this.hostedOut) {
            return registry.getConstant(SYSTEM_OUT_KEY_NAME);
        }
        if (object == this.hostedErr) {
            return registry.getConstant(SYSTEM_ERR_KEY_NAME);
        }
        if (object == this.hostedInitialErr) {
            return registry.getConstant(SYSTEM_INITIAL_ERR_KEY_NAME);
        }
        if (object == this.hostedInitialIn) {
            return registry.getConstant(SYSTEM_INITIAL_IN_KEY_NAME);
        }
        return null;
    }
}

