/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.nmt;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

class NmtVirtualMemoryInfo {
    private final UninterruptibleUtils.AtomicLong peakReservedSize = new UninterruptibleUtils.AtomicLong(0L);
    private final UninterruptibleUtils.AtomicLong peakCommittedSize = new UninterruptibleUtils.AtomicLong(0L);
    private final UninterruptibleUtils.AtomicLong reservedSize = new UninterruptibleUtils.AtomicLong(0L);
    private final UninterruptibleUtils.AtomicLong committedSize = new UninterruptibleUtils.AtomicLong(0L);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    NmtVirtualMemoryInfo() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void trackReserved(long size) {
        long newReservedSize = this.reservedSize.addAndGet(size);
        NmtVirtualMemoryInfo.updatePeak(newReservedSize, this.peakReservedSize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void trackCommitted(long size) {
        long newCommittedSize = this.committedSize.addAndGet(size);
        NmtVirtualMemoryInfo.updatePeak(newCommittedSize, this.peakCommittedSize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void trackUncommit(long size) {
        long lastSize = this.committedSize.addAndGet(-size);
        assert (lastSize >= 0L);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void trackFree(long size) {
        long lastSize = this.reservedSize.addAndGet(-size);
        assert (lastSize >= 0L);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void updatePeak(long newSize, UninterruptibleUtils.AtomicLong peakToUpdate) {
        long oldPeak;
        while (newSize > (oldPeak = peakToUpdate.get()) && !peakToUpdate.compareAndSet(oldPeak, newSize)) {
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    long getReservedSize() {
        return this.reservedSize.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    long getCommittedSize() {
        return this.committedSize.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    long getPeakReservedSize() {
        return this.peakReservedSize.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    long getPeakCommittedSize() {
        return this.peakCommittedSize.get();
    }
}

