/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.FrameSourceInfo;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.code.UntetheredCodeInfoAccess;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaFrame;
import com.oracle.svm.core.stack.JavaFrames;
import com.oracle.svm.core.stack.JavaStackFrameVisitor;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.thread.ContinuationInternals;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.Target_java_lang_VirtualThread;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_Continuation;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_ContinuationScope;
import com.oracle.svm.core.util.VMError;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

@TargetClass(value=StackWalker.class)
@Platforms(value={InternalPlatform.NATIVE_ONLY.class})
final class Target_java_lang_StackWalker {
    @Alias
    Target_jdk_internal_vm_Continuation continuation;
    @Alias
    Target_jdk_internal_vm_ContinuationScope contScope;
    @Alias
    Set<StackWalker.Option> options;
    @Alias
    boolean retainClassRef;

    Target_java_lang_StackWalker() {
    }

    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    private void forEach(final Consumer<? super StackWalker.StackFrame> action) {
        final boolean showHiddenFrames = this.options.contains((Object)StackWalker.Option.SHOW_HIDDEN_FRAMES);
        final boolean showReflectFrames = this.options.contains((Object)StackWalker.Option.SHOW_REFLECT_FRAMES);
        JavaStackWalker.walkCurrentThread(KnownIntrinsics.readCallerStackPointer(), new JavaStackFrameVisitor(this){
            final /* synthetic */ Target_java_lang_StackWalker this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean visitFrame(FrameSourceInfo frameInfo) {
                if (StackTraceUtils.shouldShowFrame(frameInfo, showHiddenFrames, showReflectFrames, showHiddenFrames)) {
                    action.accept(this.this$0.new StackFrameImpl(frameInfo));
                }
                return true;
            }
        });
    }

    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    private Class<?> getCallerClass() {
        if (!this.retainClassRef) {
            throw new UnsupportedOperationException("This stack walker does not have RETAIN_CLASS_REFERENCE access");
        }
        Class<?> result = StackTraceUtils.getCallerClass(KnownIntrinsics.readCallerStackPointer(), false);
        if (result == null) {
            throw new IllegalCallerException("No calling frame");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    private <T> T walk(Function<? super Stream<StackWalker.StackFrame>, ? extends T> function) {
        AbstractStackFrameSpliterator spliterator;
        JavaStackWalk walk = (JavaStackWalk)UnsafeStackValue.get(JavaStackWalker.sizeOfJavaStackWalk());
        if (ContinuationSupport.isSupported() && this.continuation != null) {
            spliterator = new ContinuationSpliterator(this, walk, this.contScope, this.continuation);
        } else {
            Target_jdk_internal_vm_ContinuationScope scope;
            Target_jdk_internal_vm_Continuation top;
            IsolateThread isolateThread = CurrentIsolate.getCurrentThread();
            Pointer sp = KnownIntrinsics.readCallerStackPointer();
            Pointer endSP = (Pointer)WordFactory.nullPointer();
            if (ContinuationSupport.isSupported() && (this.contScope != null || JavaThreads.isCurrentThreadVirtual()) && (top = Target_jdk_internal_vm_Continuation.getCurrentContinuation(scope = this.contScope != null ? this.contScope : Target_java_lang_VirtualThread.continuationScope())) != null) {
                endSP = ContinuationInternals.getBaseSP(top);
            }
            spliterator = new StackFrameSpliterator(this, walk, isolateThread, sp, endSP);
        }
        try {
            T t = function.apply(StreamSupport.stream(spliterator, false));
            return t;
        }
        finally {
            spliterator.invalidate();
        }
    }

    final class ContinuationSpliterator
    extends AbstractStackFrameSpliterator {
        private final Target_jdk_internal_vm_ContinuationScope contScope;
        private boolean initialized;
        private JavaStackWalk walk;
        private Target_jdk_internal_vm_Continuation continuation;
        private StoredContinuation stored;

        ContinuationSpliterator(Target_java_lang_StackWalker this$0, JavaStackWalk walk, Target_jdk_internal_vm_ContinuationScope contScope, Target_jdk_internal_vm_Continuation continuation) {
            assert (walk.isNonNull());
            this.walk = walk;
            this.contScope = contScope;
            this.continuation = continuation;
        }

        @Override
        protected boolean advancePhysically() {
            assert (this.continuation != null);
            do {
                if (this.contScope != null) {
                    while (this.continuation != null && this.continuation.getScope() != this.contScope) {
                        this.continuation = this.continuation.getParent();
                    }
                }
                if (this.continuation == null) {
                    return false;
                }
                this.stored = ContinuationInternals.getStoredContinuation(this.continuation);
                if (this.stored == null) {
                    return false;
                }
                if (this.advancePhysically0()) {
                    return true;
                }
                this.continuation = this.continuation.getParent();
                this.initialized = false;
            } while (this.continuation != null);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Uninterruptible(reason="Prevent GC while in this method.")
        private boolean advancePhysically0() {
            if (this.initialized) {
                JavaStackWalker.updateStackPointerForContinuation(this.walk, this.stored);
            } else {
                this.initialized = true;
                JavaStackWalker.initializeForContinuation(this.walk, this.stored);
            }
            if (!JavaStackWalker.advanceForContinuation(this.walk, this.stored)) {
                return false;
            }
            JavaFrame frame = JavaStackWalker.getCurrentFrame(this.walk);
            VMError.guarantee(!JavaFrames.isEntryPoint(frame), "Entry point frames are not supported");
            VMError.guarantee(!JavaFrames.isUnknownFrame(frame), "Stack walk must not encounter unknown frame");
            VMError.guarantee(Deoptimizer.checkDeoptimized(frame) == null, "Deoptimized frames are not supported");
            UntetheredCodeInfo untetheredInfo = frame.getIPCodeInfo();
            VMError.guarantee(UntetheredCodeInfoAccess.isAOTImageCode(untetheredInfo));
            Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
            try {
                CodeInfo info = CodeInfoAccess.convert(untetheredInfo, tether);
                CodeInfoQueryResult physicalFrame = ContinuationSpliterator.queryCodeInfoInterruptibly(info, frame.getIP());
                this.regularVFrame = physicalFrame.getFrameInfo();
            }
            finally {
                CodeInfoAccess.releaseTether(untetheredInfo, tether);
            }
            return true;
        }

        @Override
        protected void invalidate() {
            this.walk = (JavaStackWalk)WordFactory.nullPointer();
            this.continuation = null;
            this.stored = null;
        }

        @Override
        protected void checkState() {
            if (this.walk.isNull()) {
                throw new IllegalStateException("Continuation traversal no longer valid");
            }
        }
    }

    final class StackFrameSpliterator
    extends AbstractStackFrameSpliterator {
        private final IsolateThread thread;
        private final Pointer startSP;
        private final Pointer endSP;
        private boolean initialized = false;
        private JavaStackWalk walk;

        StackFrameSpliterator(Target_java_lang_StackWalker this$0, JavaStackWalk walk, IsolateThread thread, Pointer startSP, Pointer endSP) {
            this.walk = walk;
            this.thread = thread;
            this.startSP = startSP;
            this.endSP = endSP;
        }

        @Override
        protected void invalidate() {
            this.walk = (JavaStackWalk)WordFactory.nullPointer();
        }

        @Override
        protected void checkState() {
            if (this.walk.isNull()) {
                throw new IllegalStateException("Stack traversal no longer valid");
            }
            if (this.thread != CurrentIsolate.getCurrentThread()) {
                throw new IllegalStateException("Invalid thread");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
        protected boolean advancePhysically() {
            if (!this.initialized) {
                this.initialized = true;
                JavaStackWalker.initialize(this.walk, this.thread, this.startSP, this.endSP);
            }
            if (!JavaStackWalker.advance(this.walk, this.thread)) {
                return false;
            }
            JavaFrame frame = JavaStackWalker.getCurrentFrame(this.walk);
            VMError.guarantee(!JavaFrames.isUnknownFrame(frame), "Stack walk must not encounter unknown frame");
            DeoptimizedFrame deoptimizedFrame = Deoptimizer.checkDeoptimized(frame);
            if (deoptimizedFrame != null) {
                this.deoptimizedVFrame = deoptimizedFrame.getTopFrame();
            } else {
                UntetheredCodeInfo untetheredInfo = frame.getIPCodeInfo();
                Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
                try {
                    CodeInfo info = CodeInfoAccess.convert(untetheredInfo, tether);
                    CodeInfoQueryResult physicalFrame = StackFrameSpliterator.queryCodeInfoInterruptibly(info, frame.getIP());
                    this.regularVFrame = physicalFrame.getFrameInfo();
                }
                finally {
                    CodeInfoAccess.releaseTether(untetheredInfo, tether);
                }
            }
            return true;
        }
    }

    private abstract class AbstractStackFrameSpliterator
    implements Spliterator<StackWalker.StackFrame> {
        protected DeoptimizedFrame.VirtualFrame deoptimizedVFrame;
        protected FrameInfoQueryResult regularVFrame;

        private AbstractStackFrameSpliterator() {
        }

        @Override
        public Spliterator<StackWalker.StackFrame> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 1296;
        }

        @Uninterruptible(reason="Wraps the now safe call to query frame information.", calleeMustBe=false)
        protected static CodeInfoQueryResult queryCodeInfoInterruptibly(CodeInfo info, CodePointer ip) {
            return CodeInfoTable.lookupCodeInfoQueryResult(info, ip);
        }

        @Override
        public boolean tryAdvance(Consumer<? super StackWalker.StackFrame> action) {
            this.checkState();
            boolean showHiddenFrames = Target_java_lang_StackWalker.this.options.contains((Object)StackWalker.Option.SHOW_HIDDEN_FRAMES);
            boolean showReflectFrames = Target_java_lang_StackWalker.this.options.contains((Object)StackWalker.Option.SHOW_REFLECT_FRAMES);
            while (true) {
                FrameInfoQueryResult frameInfo;
                if (this.deoptimizedVFrame != null) {
                    frameInfo = this.deoptimizedVFrame.getFrameInfo();
                    this.deoptimizedVFrame = this.deoptimizedVFrame.getCaller();
                    if (!AbstractStackFrameSpliterator.shouldShowFrame(frameInfo, showHiddenFrames, showReflectFrames, showHiddenFrames)) continue;
                    action.accept(new StackFrameImpl(frameInfo));
                    return true;
                }
                if (this.regularVFrame != null) {
                    frameInfo = this.regularVFrame;
                    this.regularVFrame = frameInfo.getCaller();
                    if (!AbstractStackFrameSpliterator.shouldShowFrame(frameInfo, showHiddenFrames, showReflectFrames, showHiddenFrames)) continue;
                    action.accept(new StackFrameImpl(frameInfo));
                    return true;
                }
                if (!this.advancePhysically()) break;
            }
            this.invalidate();
            return false;
        }

        private static boolean shouldShowFrame(FrameInfoQueryResult frameInfo, boolean showLambdaFrames, boolean showReflectFrames, boolean showHiddenFrames) {
            return StackTraceUtils.shouldShowFrame(frameInfo, showLambdaFrames, showReflectFrames, showHiddenFrames);
        }

        protected abstract void invalidate();

        protected abstract void checkState();

        protected abstract boolean advancePhysically();
    }

    final class StackFrameImpl
    implements StackWalker.StackFrame {
        private final FrameSourceInfo frameInfo;
        private StackTraceElement ste;

        StackFrameImpl(FrameSourceInfo frameInfo) {
            this.frameInfo = frameInfo;
        }

        @Override
        public String getClassName() {
            return this.frameInfo.getSourceClassName();
        }

        @Override
        public String getMethodName() {
            return this.frameInfo.getSourceMethodName();
        }

        @Override
        public Class<?> getDeclaringClass() {
            if (!Target_java_lang_StackWalker.this.retainClassRef) {
                throw new UnsupportedOperationException("This stack walker does not have RETAIN_CLASS_REFERENCE access");
            }
            return this.frameInfo.getSourceClass();
        }

        @Override
        public int getByteCodeIndex() {
            return this.frameInfo.getBci();
        }

        @Override
        public String getFileName() {
            return this.frameInfo.getSourceFileName();
        }

        @Override
        public int getLineNumber() {
            return this.frameInfo.getSourceLineNumber();
        }

        @Override
        public boolean isNativeMethod() {
            return this.frameInfo.isNativeMethod();
        }

        @Override
        public StackTraceElement toStackTraceElement() {
            if (this.ste == null) {
                this.ste = this.frameInfo.getSourceReference();
            }
            return this.ste;
        }

        public String toString() {
            return this.toStackTraceElement().toString();
        }
    }
}

