/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ClassUtil;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Value;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateForeignCallLinkage
implements ForeignCallLinkage {
    private final SubstrateForeignCallsProvider provider;
    private final SnippetRuntime.SubstrateForeignCallDescriptor descriptor;
    private final ResolvedJavaMethod method;
    private CallingConvention outgoingCallingConvention;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateForeignCallLinkage(SubstrateForeignCallsProvider provider, SnippetRuntime.SubstrateForeignCallDescriptor descriptor) {
        this.provider = provider;
        this.descriptor = descriptor;
        this.method = descriptor.findMethod(provider.metaAccess);
    }

    public CallingConvention getOutgoingCallingConvention() {
        if (this.outgoingCallingConvention == null) {
            ResolvedJavaType resType = this.provider.metaAccess.lookupJavaType(this.descriptor.getResultType());
            ResolvedJavaType[] argTypes = this.provider.metaAccess.lookupJavaTypes(this.descriptor.getArgumentTypes());
            SubstrateCallingConventionKind callingConventionKind = ((SharedMethod)this.method).getCallingConventionKind();
            this.outgoingCallingConvention = this.provider.registerConfig.getCallingConvention((CallingConvention.Type)callingConventionKind.toType(true), (JavaType)resType, (JavaType[])argTypes, (ValueKindFactory)this.provider);
        }
        return this.outgoingCallingConvention;
    }

    public CallingConvention getIncomingCallingConvention() {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public long getMaxCallTargetOffset() {
        return -1L;
    }

    public boolean destroysRegisters() {
        return true;
    }

    public boolean needsDebugInfo() {
        return this.descriptor.needsDebugInfo();
    }

    public SnippetRuntime.SubstrateForeignCallDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ResolvedJavaMethod getMethod() {
        return this.method;
    }

    public Value[] getTemporaries() {
        return AllocatableValue.NONE;
    }

    public String toString() {
        return "RuntimeCall<" + ClassUtil.getUnqualifiedName(this.descriptor.getDeclaringClass()) + "." + this.descriptor.getName() + ">";
    }
}

