/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;

public final class AMD64LoadMethodPointerConstantOp
extends AMD64LIRInstruction
implements StandardOp.LoadConstantOp {
    public static final LIRInstructionClass<AMD64LoadMethodPointerConstantOp> TYPE = LIRInstructionClass.create(AMD64LoadMethodPointerConstantOp.class);
    private final SubstrateMethodPointerConstant constant;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
    private AllocatableValue result;

    AMD64LoadMethodPointerConstantOp(AllocatableValue result, SubstrateMethodPointerConstant constant) {
        super(TYPE);
        this.constant = constant;
        this.result = result;
    }

    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register resultReg = ValueUtil.asRegister((Value)this.result);
        crb.recordInlineDataInCode((Constant)this.constant);
        masm.leaq(resultReg, masm.getPlaceholder(masm.position()));
    }

    public AllocatableValue getResult() {
        return this.result;
    }

    public SubstrateMethodPointerConstant getConstant() {
        return this.constant;
    }

    public boolean canRematerializeToStack() {
        return false;
    }
}

