/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.fieldvaluetransformer;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.graal.nodes.FieldOffsetNode;
import com.oracle.svm.core.reflect.target.ReflectionSubstitutionSupport;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

public record FieldOffsetFieldValueTransformer(Field targetField, JavaKind returnKind) implements FieldValueTransformerWithAvailability
{
    @Override
    public boolean isAvailable() {
        return BuildPhaseProvider.isHostedUniverseBuilt();
    }

    public Object transform(Object receiver, Object originalValue) {
        int offset = ReflectionSubstitutionSupport.singleton().getFieldOffset(this.targetField, true);
        if (offset <= 0) {
            throw VMError.shouldNotReachHere("Field is not marked as unsafe accessed: " + String.valueOf(this.targetField));
        }
        return FieldOffsetFieldValueTransformer.box(this.returnKind, offset);
    }

    static Object box(JavaKind returnKind, int value) {
        switch (returnKind) {
            case Int: {
                return value;
            }
            case Long: {
                return (long)value;
            }
        }
        throw VMError.shouldNotReachHere("Unexpected kind: " + String.valueOf(returnKind));
    }

    @Override
    public ValueNode intrinsify(CoreProviders providers, JavaConstant receiver) {
        return FieldOffsetNode.create(this.returnKind, providers.getMetaAccess().lookupJavaField(this.targetField));
    }
}

