/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.truffle;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.truffle.TruffleBaseFeature;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateHostFeatureEnabled;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.graalvm.jniutils.JNIEntryPoint;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeJNIAccess;

public final class PolyglotIsolateHostFeature
implements InternalFeature {
    public void afterRegistration(Feature.AfterRegistrationAccess afterRegistrationAccess) {
        if (PolyglotIsolateHostFeature.k()) {
            ImageSingletons.add(PolyglotIsolateHostFeatureEnabled.class, (Object)new PolyglotIsolateHostFeatureEnabled());
        }
    }

    public String getDescription() {
        return "Provides polyglot host isolate embedding support";
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess beforeAnalysisAccess) {
        if (PolyglotIsolateHostFeature.k()) {
            PolyglotIsolateHostFeature.a((FeatureImpl.BeforeAnalysisAccessImpl)beforeAnalysisAccess);
        }
    }

    private static Class<?> n() {
        try {
            return Class.forName("com.oracle.truffle.polyglot.enterprise.PolyglotIsolateHostFeatureEnabled");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static boolean k() {
        return ImageSingletons.contains(TruffleBaseFeature.class) && (Boolean)SubstrateOptions.JNI.getValue() != false && (Boolean)SubstrateOptions.SpawnIsolates.getValue() != false && PolyglotIsolateHostFeature.n() != null;
    }

    private static void a(FeatureImpl.BeforeAnalysisAccessImpl beforeAnalysisAccessImpl) {
        try {
            ImageClassLoader imageClassLoader = beforeAnalysisAccessImpl.getImageClassLoader();
            ArrayList<Method> arrayList = new ArrayList<Method>();
            arrayList.addAll(PolyglotIsolateHostFeature.a("org.graalvm.jniutils.JNIExceptionWrapperEntryPoints", JNIEntryPoint.class));
            arrayList.addAll(PolyglotIsolateHostFeature.a("org.graalvm.nativebridge.ForeignExceptionEndPoints", JNIEntryPoint.class));
            arrayList.addAll(imageClassLoader.findAnnotatedMethods(JNIEntryPoint.class));
            arrayList.stream().map(Method::getDeclaringClass).distinct().forEach(clazz -> RuntimeJNIAccess.register((Class[])new Class[]{clazz}));
            arrayList.forEach(executable -> RuntimeJNIAccess.register((Executable[])new Executable[]{executable}));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            UserError.abort((Throwable)reflectiveOperationException, (String)"Failed to register JNI entry points.", (Object[])new Object[0]);
        }
    }

    private static Collection<Method> a(String string, Class<? extends Annotation> clazz) throws ReflectiveOperationException {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Class<?> clazz2 = Class.forName(string);
        for (Method method : clazz2.getDeclaredMethods()) {
            if (AnnotationAccess.getAnnotation((AnnotatedElement)method, clazz) == null) continue;
            arrayList.add(method);
        }
        return arrayList;
    }
}

