/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import java.util.Collection;
import java.util.List;

final class DefaultInvokeTypeFlowUtil {
    DefaultInvokeTypeFlowUtil() {
    }

    static Collection<MethodFlowsGraph> getAllNonStubCalleesFlows(InvokeTypeFlow typeFlow) {
        if (typeFlow.linksOnlyOriginalCallees()) {
            List<MethodFlowsGraph> callees = typeFlow.getAllCallees().stream().map(method -> PointsToAnalysis.assertPointsToAnalysisMethod(method).getTypeFlow().getMethodFlowsGraph()).toList();
            assert (callees.stream().noneMatch(MethodFlowsGraph::isStub)) : callees;
            return callees;
        }
        return typeFlow.getAllCallees().stream().map(method -> PointsToAnalysis.assertPointsToAnalysisMethod(method).getTypeFlow().getMethodFlowsGraph()).filter(graph -> !graph.isStub()).toList();
    }
}

