/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.MultiRelease;
import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.spi.CipherAlg;
import com.oracle.jipher.internal.spi.CipherMode;
import com.oracle.jipher.internal.spi.CipherPadding;
import com.oracle.jipher.internal.spi.SymmCipher;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public abstract class WrapCipher
extends SymmCipher {
    static final int UNIT_BYTES = 8;
    private State state;
    private Object cleanable;

    WrapCipher(CipherAlg ciph, CipherMode mode) {
        super(ciph);
        this.mode = mode;
        this.padding = CipherPadding.NOPADDING;
    }

    void appendToInputBuf(byte[] input, int inOffset, int inLen) {
        if (this.state == null) {
            this.state = new State(ByteBuffer.allocate(inLen));
            if (this.encrypt) {
                this.cleanable = MultiRelease.CLEANER_INSTANCE.register(this, this.state);
            }
        } else if (inLen > this.state.inputBuffer.remaining()) {
            int requiredSize;
            try {
                requiredSize = Math.addExact(this.state.inputBuffer.position(), inLen);
            }
            catch (ArithmeticException e) {
                throw new ProviderException("JipherJCE provider only supports KeyWrap input data of up to 2147483647 bytes");
            }
            int newSize = Math.max(this.state.inputBuffer.capacity() < 0x3FFFFFFF ? this.state.inputBuffer.capacity() * 2 : 0, requiredSize);
            ByteBuffer oldInputBuffer = this.state.inputBuffer;
            Object oldCleanable = this.cleanable;
            this.state = new State(ByteBuffer.allocate(newSize));
            if (this.encrypt) {
                this.cleanable = MultiRelease.CLEANER_INSTANCE.register(this, this.state);
            }
            oldInputBuffer.flip();
            this.state.inputBuffer.put(oldInputBuffer);
            if (oldCleanable != null) {
                MultiRelease.clean(oldCleanable);
            }
        }
        this.state.inputBuffer.put(input, inOffset, inLen);
    }

    @Override
    protected void engineSetMode(String s) throws NoSuchAlgorithmException {
        if (!s.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException(s + " cannot be used");
        }
    }

    @Override
    protected void engineSetPadding(String s) throws NoSuchPaddingException {
        if (!s.equalsIgnoreCase("NoPadding")) {
            throw new NoSuchPaddingException(s + " cannot be used");
        }
    }

    @Override
    protected void engineInit(int cipherMode, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters != null) {
            throw new InvalidAlgorithmParameterException("Parameters not expected for key wrap cipher");
        }
        super.engineInit(cipherMode, key, (AlgorithmParameters)null, secureRandom);
    }

    @Override
    protected int engineUpdate(byte[] input, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException {
        this.checkIfInited();
        this.updateCalled = true;
        if (inLen > 0) {
            this.appendToInputBuf(input, inOffset, inLen);
        }
        return 0;
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inOffset, int inLen) {
        this.checkIfInited();
        this.updateCalled = true;
        if (inLen > 0) {
            this.appendToInputBuf(input, inOffset, inLen);
        }
        return new byte[0];
    }

    @Override
    protected int engineDoFinal(byte[] input, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n;
        int minOutputSize;
        this.checkIfInited();
        int outputSize = this.engineGetOutputSize(inLen);
        int n2 = minOutputSize = !this.encrypt && this.mode == CipherMode.KWP && outputSize >= 8 ? outputSize - 8 : outputSize;
        if (minOutputSize > out.length - outOffset) {
            throw new ShortBufferException("Not enough space in output array");
        }
        byte[] outputBounceBuffer = null;
        byte[] savedOutputData = null;
        boolean doCleanup = true;
        try {
            int outBufOffset;
            byte[] outBuf;
            int position;
            int n3 = position = this.state != null ? this.state.inputBuffer.position() : 0;
            if (this.mode == CipherMode.KW || !this.encrypt) {
                boolean unitBytesMultiple;
                int totalInput = Math.addExact(position, inLen);
                boolean bl = unitBytesMultiple = (totalInput & 7) == 0;
                if (!unitBytesMultiple || !this.encrypt && totalInput < 16) {
                    throw new IllegalBlockSizeException("Invalid input size");
                }
            }
            if (!this.encrypt && this.mode == CipherMode.KWP && outputSize > out.length - outOffset) {
                outputBounceBuffer = new byte[outputSize];
                outBuf = outputBounceBuffer;
                outBufOffset = 0;
            } else {
                outBuf = out;
                outBufOffset = outOffset;
                if (minOutputSize < outputSize) {
                    savedOutputData = Arrays.copyOfRange(outBuf, outBufOffset + minOutputSize, outBufOffset + outputSize);
                }
            }
            if (position > 0 || inLen > 0 && WrapCipher.isOverlapping(input, inOffset, inLen, outBuf, outBufOffset, outputSize) && inOffset != outBufOffset) {
                if (inLen > 0) {
                    this.appendToInputBuf(input, inOffset, inLen);
                }
                input = this.state.inputBuffer.array();
                inOffset = this.state.inputBuffer.arrayOffset();
                inLen = this.state.inputBuffer.position();
            }
            int outLen = this.ctx.update(input, inOffset, inLen, outBuf, outBufOffset);
            if ((outLen += this.ctx.doFinal(outBuf, outBufOffset + outLen)) < outputSize && outLen >= minOutputSize && savedOutputData != null) {
                System.arraycopy(savedOutputData, outLen - minOutputSize, outBuf, outBufOffset + outLen, outputSize - outLen);
            }
            if (outLen > outBuf.length - outBufOffset) {
                throw new Error("Internal error: buffer overrun");
            }
            if (outputBounceBuffer != null) {
                if (outLen > out.length - outOffset) {
                    doCleanup = false;
                    if (position > 0) {
                        this.state.inputBuffer.position(position);
                    }
                    throw new ShortBufferException("Not enough space in output array");
                }
                System.arraycopy(outputBounceBuffer, 0, out, outOffset, outLen);
            }
            n = outLen;
        }
        catch (ProviderException e) {
            try {
                if (this.encrypt) {
                    IllegalBlockSizeException ibse = new IllegalBlockSizeException(e.getMessage());
                    ibse.initCause(e.getCause());
                    throw ibse;
                }
                BadPaddingException bpe = new BadPaddingException(e.getMessage());
                bpe.initCause(e.getCause());
                throw bpe;
            }
            catch (Throwable throwable) {
                Util.clearArray(outputBounceBuffer);
                Util.clearArray(savedOutputData);
                if (doCleanup) {
                    this.cleanup();
                }
                throw throwable;
            }
        }
        Util.clearArray(outputBounceBuffer);
        Util.clearArray(savedOutputData);
        if (doCleanup) {
            this.cleanup();
        }
        return n;
    }

    @Override
    int getUpdateOutputSize(int inputLen) {
        return 0;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        boolean unitBytesMultiple;
        int totalInput = Math.addExact(this.state != null ? this.state.inputBuffer.position() : 0, inputLen);
        boolean bl = unitBytesMultiple = (totalInput & 7) == 0;
        if (this.encrypt) {
            return unitBytesMultiple || this.mode == CipherMode.KWP ? totalInput + 16 - 1 & 0xFFFFFFF8 : 0;
        }
        return unitBytesMultiple && totalInput >= 16 ? totalInput - 8 : 0;
    }

    @Override
    String getAlgorithmParametersAlg() {
        throw new UnsupportedOperationException();
    }

    @Override
    AlgorithmParameterSpec getParamSpec(byte[] iv, AlgorithmParameterSpec spec) {
        return null;
    }

    @Override
    byte[] verifyParams(AlgorithmParameterSpec params, boolean encrypt) throws InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not expected for key wrap cipher");
        }
        return null;
    }

    @Override
    Class<? extends AlgorithmParameterSpec> getParameterSpecClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    void cleanup() {
        this.updateCalled = false;
        this.state = null;
        if (this.cleanable != null) {
            MultiRelease.clean(this.cleanable);
            this.cleanable = null;
        }
    }

    public static class AesWrapPad256
    extends WrapCipher {
        public AesWrapPad256() {
            super(new CipherAlg.AesKeyWrap(256), CipherMode.KWP);
        }
    }

    public static class AesWrapPad192
    extends WrapCipher {
        public AesWrapPad192() {
            super(new CipherAlg.AesKeyWrap(192), CipherMode.KWP);
        }
    }

    public static class AesWrapPad128
    extends WrapCipher {
        public AesWrapPad128() {
            super(new CipherAlg.AesKeyWrap(128), CipherMode.KWP);
        }
    }

    public static class AesWrapPad
    extends WrapCipher {
        public AesWrapPad() {
            super(new CipherAlg.AesKeyWrap(), CipherMode.KWP);
        }
    }

    public static class AesWrap256
    extends WrapCipher {
        public AesWrap256() {
            super(new CipherAlg.AesKeyWrap(256), CipherMode.KW);
        }
    }

    public static class AesWrap192
    extends WrapCipher {
        public AesWrap192() {
            super(new CipherAlg.AesKeyWrap(192), CipherMode.KW);
        }
    }

    public static class AesWrap128
    extends WrapCipher {
        public AesWrap128() {
            super(new CipherAlg.AesKeyWrap(128), CipherMode.KW);
        }
    }

    public static class AesWrap
    extends WrapCipher {
        public AesWrap() {
            super(new CipherAlg.AesKeyWrap(), CipherMode.KW);
        }
    }

    static final class State
    implements Runnable {
        final ByteBuffer inputBuffer;

        State(ByteBuffer inputBuffer) {
            this.inputBuffer = inputBuffer;
        }

        @Override
        public final void run() {
            Util.clearArray(this.inputBuffer.array());
        }
    }
}

