/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.loader;

import com.oracle.jipher.internal.common.Debug;
import com.oracle.jipher.internal.loader.FileUtil;
import com.oracle.jipher.internal.loader.LibraryLoaderContext;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;

class TempLibraryCleaner {
    private static final Debug DEBUG = Debug.getInstance("jipher");
    private final LibraryLoaderContext loaderContext;
    private final FileUtil fileUtil;

    TempLibraryCleaner(LibraryLoaderContext loaderContext) {
        this.loaderContext = loaderContext;
        this.fileUtil = new FileUtil(loaderContext.getPlatform());
    }

    void cleanupDirs() {
        try {
            Path libtmpPath = Paths.get(this.loaderContext.getLibTmpDir(), new String[0]);
            if (!Files.exists(libtmpPath, new LinkOption[0]) || !Files.isDirectory(libtmpPath, new LinkOption[0])) {
                DEBUG.println("No directories to clean");
                return;
            }
            List<String> fileNames = this.loaderContext.getPlatform().getLibFiles();
            fileNames.add(this.loaderContext.getPlatform().getOpensslCnfFile());
            DirectoryStream.Filter<Path> jipherTmpFilter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) {
                    try {
                        return Files.isDirectory(entry, new LinkOption[0]) && entry.getFileName().toString().startsWith(TempLibraryCleaner.this.loaderContext.getRandomDirPrefix());
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            };
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(libtmpPath, (DirectoryStream.Filter<? super Path>)jipherTmpFilter);){
                for (Path dir : ds) {
                    HashSet<Path> potentialOrphans = new HashSet<Path>();
                    DEBUG.println("Scanning " + dir);
                    boolean anyFileExists = false;
                    for (String fName : fileNames) {
                        Path fPath = dir.resolve(fName);
                        potentialOrphans.add(fPath);
                        if (!Files.exists(fPath, new LinkOption[0])) continue;
                        anyFileExists = true;
                    }
                    if (!anyFileExists) continue;
                    Path ldg = dir.resolve("jipher.ldg");
                    if (Files.exists(ldg, new LinkOption[0])) {
                        DEBUG.println("No attempt to delete inside " + dir + " since " + ldg + " exists");
                        continue;
                    }
                    for (Path orphan : potentialOrphans) {
                        Files.deleteIfExists(orphan);
                    }
                    this.fileUtil.tryDelete(dir, false);
                }
            }
        }
        catch (Exception e) {
            DEBUG.println("Caught exception trying to cleanup: " + e.getMessage());
        }
    }
}

