/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.aotjs.wasmgc;

import com.oracle.svm.core.JavaMemoryUtil;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.ArrayUtil;
import com.oracle.svm.hosted.aotjs.wasm.snippets.d;
import java.util.HashMap;
import java.util.Map;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.extended.ForeignCallWithExceptionNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopyNode;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

public class u {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CE = SnippetRuntime.findForeignCall(u.class, (String)"doArraycopy", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] CF = new SnippetRuntime.SubstrateForeignCallDescriptor[]{CE};
    public static final Map<d, JavaKind> CG = new HashMap<d, JavaKind>();
    public static final d CH = u.m(JavaKind.Byte);
    public static final d CI = u.m(JavaKind.Boolean);
    public static final d CJ = u.m(JavaKind.Short);
    public static final d CK = u.m(JavaKind.Char);
    public static final d CL = u.m(JavaKind.Int);
    public static final d CM = u.m(JavaKind.Long);
    public static final d CN = u.m(JavaKind.Float);
    public static final d CO = u.m(JavaKind.Double);
    public static final d CP = u.m(JavaKind.Object);

    private static d m(JavaKind javaKind) {
        d d2 = new d("arraycopy." + String.valueOf(javaKind), Void.TYPE, new Class[]{Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE});
        CG.put(d2, javaKind);
        return d2;
    }

    public static void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(CF);
    }

    public static void b(Map<Class<? extends Node>, NodeLoweringProvider<?>> map) {
        map.put(ArrayCopyNode.class, new a());
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static void doArraycopy(Object fromArray, int fromIndex, Object toArray, int toIndex, int length) {
        if (fromArray == null || toArray == null) {
            throw new NullPointerException();
        }
        DynamicHub dynamicHub = KnownIntrinsics.readHub((Object)fromArray);
        Class clazz = DynamicHub.toClass((DynamicHub)dynamicHub);
        DynamicHub dynamicHub2 = KnownIntrinsics.readHub((Object)toArray);
        int n2 = dynamicHub.getLayoutEncoding();
        if (LayoutEncoding.isArray((int)n2)) {
            if (dynamicHub == dynamicHub2) {
                ArrayUtil.boundsCheckInSnippet((Object)fromArray, (int)fromIndex, (Object)toArray, (int)toIndex, (int)length);
                if (clazz == byte[].class) {
                    u.copy(CH, fromArray, fromIndex, toArray, toIndex, length);
                } else if (clazz == boolean[].class) {
                    u.copy(CI, fromArray, fromIndex, toArray, toIndex, length);
                } else if (clazz == short[].class) {
                    u.copy(CJ, fromArray, fromIndex, toArray, toIndex, length);
                } else if (clazz == char[].class) {
                    u.copy(CK, fromArray, fromIndex, toArray, toIndex, length);
                } else if (clazz == int[].class) {
                    u.copy(CL, fromArray, fromIndex, toArray, toIndex, length);
                } else if (clazz == long[].class) {
                    u.copy(CM, fromArray, fromIndex, toArray, toIndex, length);
                } else if (clazz == float[].class) {
                    u.copy(CN, fromArray, fromIndex, toArray, toIndex, length);
                } else if (clazz == double[].class) {
                    u.copy(CO, fromArray, fromIndex, toArray, toIndex, length);
                } else {
                    assert (LayoutEncoding.isObjectArray((int)n2));
                    u.copy(CP, fromArray, fromIndex, toArray, toIndex, length);
                }
                return;
            }
            if (LayoutEncoding.isObjectArray((int)n2) && LayoutEncoding.isObjectArray((int)dynamicHub2.getLayoutEncoding())) {
                ArrayUtil.boundsCheckInSnippet((Object)fromArray, (int)fromIndex, (Object)toArray, (int)toIndex, (int)length);
                if (DynamicHub.toClass((DynamicHub)dynamicHub2).isAssignableFrom(DynamicHub.toClass((DynamicHub)dynamicHub))) {
                    u.copy(CP, fromArray, fromIndex, toArray, toIndex, length);
                } else {
                    JavaMemoryUtil.copyObjectArrayForwardWithStoreCheck((Object)fromArray, (int)fromIndex, (Object)toArray, (int)toIndex, (int)length);
                }
                return;
            }
        }
        throw new ArrayStoreException();
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void copy(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1, int var2, Object var3, int var4, int var5);

    static final class a
    implements NodeLoweringProvider<ArrayCopyNode> {
        a() {
        }

        public void a(ArrayCopyNode arrayCopyNode, LoweringTool loweringTool) {
            StructuredGraph structuredGraph = arrayCopyNode.graph();
            ForeignCallWithExceptionNode foreignCallWithExceptionNode = (ForeignCallWithExceptionNode)structuredGraph.add((Node)new ForeignCallWithExceptionNode((ForeignCallDescriptor)CE, new ValueNode[]{arrayCopyNode.getSource(), arrayCopyNode.getSourcePosition(), arrayCopyNode.getDestination(), arrayCopyNode.getDestinationPosition(), arrayCopyNode.getLength()}));
            foreignCallWithExceptionNode.setStateAfter(arrayCopyNode.stateAfter());
            foreignCallWithExceptionNode.setStateDuring(arrayCopyNode.stateDuring());
            foreignCallWithExceptionNode.setBci(arrayCopyNode.bci());
            structuredGraph.replaceWithExceptionSplit((WithExceptionNode)arrayCopyNode, (WithExceptionNode)foreignCallWithExceptionNode);
        }

        public /* synthetic */ void lower(Node node, LoweringTool loweringTool) {
            this.a((ArrayCopyNode)node, loweringTool);
        }
    }
}

