/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.aotjs.wasm.gc;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.aotjs.wasm.gc.ac;
import com.oracle.svm.hosted.aotjs.wasm.nodes.j;
import com.oracle.svm.hosted.aotjs.wasm.nodes.k;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.word.Word;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class c {
    public static final Pointer Ar = (Pointer)WordFactory.pointer((long)4096L);
    public static final CGlobalData<Word> As = CGlobalDataFactory.forSymbol((String)"__webimage_heap_size");
    public static final CGlobalData<Word> At = CGlobalDataFactory.forSymbol((String)"__webimage_stack_size");
    public static final CGlobalData<Word> Au = CGlobalDataFactory.forSymbol((String)"__webimage_heap_top");
    public static final CGlobalData<Word> Av = CGlobalDataFactory.forSymbol((String)"__webimage_stack_bottom");
    public static final CGlobalData<Word> Aw = CGlobalDataFactory.forSymbol((String)"__webimage_stack_base");
    public static final CGlobalData<Word> Ax = CGlobalDataFactory.forSymbol((String)"__webimage_allocator_base");
    private static Pointer Ay = (Pointer)WordFactory.nullPointer();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static int a(EconomicMap<CGlobalData<?>, UnsignedWord> economicMap, int n2, int n3) {
        Pointer pointer = Ar.add(n2);
        Pointer pointer2 = (Pointer)c.a((UnsignedWord)pointer);
        Pointer pointer3 = pointer2.add(c.pageSize().multiply(n3));
        economicMap.put(As, (Object)WordFactory.unsigned((int)n2));
        economicMap.put(At, (Object)WordFactory.unsigned((int)n3));
        economicMap.put(Au, (Object)pointer);
        economicMap.put(Av, (Object)pointer2);
        economicMap.put(Aw, (Object)pointer3);
        economicMap.put(Ax, (Object)pointer3);
        economicMap.put((Object)Isolates.IMAGE_HEAP_BEGIN, (Object)Ar);
        economicMap.put((Object)Isolates.IMAGE_HEAP_END, (Object)pointer);
        return (int)pointer3.rawValue();
    }

    @Node.NodeIntrinsic(value=k.class)
    public static native int pages();

    @Node.NodeIntrinsic(value=j.class)
    public static native UnsignedWord grow(UnsignedWord var0);

    @AlwaysInline(value="Is lowered to a constant")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer hn() {
        return (Pointer)Av.get();
    }

    @AlwaysInline(value="Is lowered to a constant")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer ho() {
        return (Pointer)Aw.get();
    }

    @AlwaysInline(value="Is lowered to a constant")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer hp() {
        return (Pointer)Ax.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer hq() {
        return Ay;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called during initialization")
    private static void a(Pointer pointer) {
        assert (pointer.belowOrEqual(c.hr())) : "Allocator top is above end of memory";
        assert (pointer.aboveOrEqual((UnsignedWord)Ay)) : "Allocator top is below old top";
        assert (c.a((UnsignedWord)pointer).equal((UnsignedWord)pointer)) : "Allocator top is not page-aligned";
        Ay = pointer;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called during initialization")
    public static UnsignedWord hr() {
        return c.pageSize().multiply(c.pages());
    }

    @Fold
    public static UnsignedWord pageSize() {
        return WordFactory.unsigned((int)65536);
    }

    @Uninterruptible(reason="Runs while module is constructed", callerMustBe=true)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Allocator not yet initialized")
    public static void dj() {
        c.a(c.hp());
        assert (c.hs());
        ac.dj();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called during initialization")
    public static boolean hs() {
        VMError.guarantee((boolean)UnsignedUtils.isAMultiple((UnsignedWord)c.hn(), (UnsignedWord)c.pageSize()));
        VMError.guarantee((boolean)UnsignedUtils.isAMultiple((UnsignedWord)c.hp(), (UnsignedWord)c.pageSize()));
        VMError.guarantee((boolean)UnsignedUtils.isAMultiple((UnsignedWord)Ay, (UnsignedWord)c.pageSize()));
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called during initialization")
    public static UnsignedWord a(UnsignedWord unsignedWord) {
        return UnsignedUtils.roundUp((UnsignedWord)unsignedWord, (UnsignedWord)c.pageSize());
    }

    @Uninterruptible(reason="Modifies memory size.")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called during initialization")
    public static boolean b(UnsignedWord unsignedWord) {
        int n2 = c.pages();
        UnsignedWord unsignedWord2 = c.a(unsignedWord).unsignedDivide(c.pageSize());
        if (unsignedWord2.aboveThan(n2)) {
            return c.c(unsignedWord2.subtract(n2));
        }
        return true;
    }

    @Uninterruptible(reason="Modifies memory size.")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called during initialization")
    public static boolean c(UnsignedWord unsignedWord) {
        if (BranchProbabilityNode.probability((double)1.0000000000287557E-6, (boolean)unsignedWord.equal(0))) {
            return true;
        }
        UnsignedWord unsignedWord2 = c.grow(unsignedWord);
        return !unsignedWord2.equal(WordFactory.unsigned((int)-1));
    }

    @Uninterruptible(reason="Modifies memory size.")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    public static Pointer b(Pointer pointer) {
        Pointer pointer2 = (Pointer)c.a((UnsignedWord)pointer);
        if (c.b((UnsignedWord)pointer2)) {
            c.a(pointer2);
            return c.hq();
        }
        return (Pointer)WordFactory.nullPointer();
    }
}

