/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.aotjs.longemulation;

import org.graalvm.aotjs.api.JS;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={com.oracle.svm.aotjs.platform.a.class})
public class a {
    private static final int MASK_32 = -1;
    private static final int HWORD = 65535;
    private static final int HWORDW = 16;
    private static final int IntMinValue = Integer.MIN_VALUE;
    private static final int AskRemainder = 0;
    private static final int AskQuotient = 1;
    private static final int UnsignedSafeDoubleMask = -2097152;
    private static final double TwoPow32 = 4.294967296E9;
    public static a LongZero = new a(0, 0);
    public static a LongMinValue = new a(0, Integer.MIN_VALUE);
    public static a LongMaxValue = new a(-1, Integer.MAX_VALUE);
    private final int low;
    private final int high;

    public a(int n2, int n3) {
        this.low = n2;
        this.high = n3;
    }

    public static a fromInt(int n2) {
        return new a(n2, n2 >> 31);
    }

    @com.oracle.svm.aotjs.annotation.a
    @JS(value="return a | 0;")
    private static native int rawToInt(double var0);

    public static a fromDouble(double number) {
        if (Double.isNaN(number)) {
            return LongZero;
        }
        if (number >= 9.223372036854776E18) {
            return LongMaxValue;
        }
        if (number <= -9.223372036854776E18) {
            return LongMinValue;
        }
        int n2 = a.rawToInt(number % 4.294967296E9);
        int n3 = a.rawToInt(number / 4.294967296E9);
        if (number < 0.0 && n2 != 0) {
            --n3;
        }
        return new a(n2, n3);
    }

    private static a fromUnsignedSafeDouble(double number) {
        return new a(a.unsignedSafeDoubleLo(number), a.unsignedSafeDoubleHi(number));
    }

    private static int unsignedSafeDoubleHi(double number) {
        return a.rawToInt(number / 4.294967296E9);
    }

    private static int unsignedSafeDoubleLo(double number) {
        return a.rawToInt(number);
    }

    private static a addInternal(int low1, int high1, int low2, int high2) {
        int n2 = low1 + low2;
        int n3 = (n2 ^ Integer.MIN_VALUE) < (low1 ^ Integer.MIN_VALUE) ? high1 + high2 + 1 : high1 + high2;
        return new a(n2, n3);
    }

    private static a subInternal(int l1, int h1, int l2, int h2) {
        int n2 = l1 - l2;
        int n3 = (n2 ^ Integer.MIN_VALUE) > (l1 ^ Integer.MIN_VALUE) ? h1 - h2 - 1 : h1 - h2;
        return a.fromTwoInt(n2, n3);
    }

    private static a mulInternal(int l1, int h1, int l2, int h2) {
        int n2 = l1 & 0xFFFF;
        int n3 = l1 >>> 16;
        int n4 = l2 & 0xFFFF;
        int n5 = l2 >>> 16;
        int n6 = n2 * n4;
        int n7 = n3 * n4;
        int n8 = n2 * n5;
        int n9 = n6 + (n7 + n8 << 16);
        int n10 = (n6 >>> 16) + n8;
        int n11 = l1 * h2 + h1 * l2 + n3 * n5 + (n10 >>> 16) + ((n10 & 0xFFFF) + n7 >>> 16);
        return a.fromTwoInt(n9, n11);
    }

    private static boolean isInt32(int l2, int h2) {
        return h2 == l2 >> 31;
    }

    private static a absInternal(int low, int high) {
        if (high < 0) {
            int n2 = low != 0 ? ~high : -high;
            return new a(-low, n2);
        }
        return new a(low, high);
    }

    private static a divInternal(int l1, int h1, int l2, int h2) {
        if (a.isInt32(l1, h1)) {
            if (a.isInt32(l2, h2)) {
                if (l1 == Integer.MIN_VALUE && l2 == -1) {
                    return new a(Integer.MIN_VALUE, 0);
                }
                int n2 = l1 / l2;
                return new a(n2, n2 >> 31);
            }
            if (l1 == Integer.MIN_VALUE && l2 == Integer.MIN_VALUE && h2 == 0) {
                return new a(-1, -1);
            }
            return LongZero;
        }
        boolean bl = h1 < 0;
        boolean bl2 = h2 < 0;
        int n3 = l1;
        int n4 = h1;
        int n5 = l2;
        int n6 = h2;
        if (h2 < 0) {
            n6 = l2 != 0 ? ~h2 : -h2;
            n5 = -l2;
        }
        if (h1 < 0) {
            n4 = l1 != 0 ? ~h1 : -h1;
            n3 = -l1;
        }
        a a2 = a.divUnsignedInternal(n3, n4, n5, n6);
        if (bl && !bl2 || !bl && bl2) {
            int n7 = ~a2.low;
            int n8 = ~a2.high;
            if (++n7 == 0) {
                ++n8;
            }
            return new a(n7, n8);
        }
        return a2;
    }

    private static a modInternal(int l1, int h1, int l2, int h2) {
        if (a.isInt32(l1, h1)) {
            if (a.isInt32(l2, h2)) {
                return a.fromTwoInt(l1 % l2, l1 >> 31);
            }
            if (l1 == Integer.MIN_VALUE && l2 == Integer.MIN_VALUE && h2 == 0) {
                return LongZero;
            }
            return a.fromTwoInt(l1, h1);
        }
        int n2 = l1;
        int n3 = h1;
        int n4 = l2;
        int n5 = h2;
        if (h2 < 0) {
            n5 = l2 != 0 ? ~h2 : -h2;
            n4 = -l2;
        }
        if (h1 < 0) {
            n3 = l1 != 0 ? ~h1 : -h1;
            n2 = -l1;
        }
        a a2 = a.modUnsignedInternal(n2, n3, n4, n5);
        int n6 = a2.low;
        int n7 = a2.high;
        if (h1 < 0) {
            n6 = ~a2.low;
            n7 = ~a2.high;
            if (++n6 == 0) {
                ++n7;
            }
        }
        return new a(n6, n7);
    }

    private static a divUnsignedInternal(int l1, int h1, int l2, int h2) {
        if (a.isUnsignedSafeDouble(h1)) {
            if (a.isUnsignedSafeDouble(h2)) {
                double d2 = a.toNumber(new a(l1, h1));
                double d3 = a.toNumber(new a(l2, h2));
                double d4 = d2 / d3;
                return a.fromUnsignedSafeDouble(d4);
            }
            return LongZero;
        }
        if (h2 == 0 && a.isPowerOfTwoIKnowItsNotZero(l2)) {
            int n2 = a.log2OfPowerOfTwo(l2);
            return a.fromTwoInt(l1 >>> n2 | h1 << 1 << 31 - n2, h1 >>> n2);
        }
        if (l2 == 0 && a.isPowerOfTwoIKnowItsNotZero(h2)) {
            int n3 = a.log2OfPowerOfTwo(h2);
            return a.fromTwoInt(h1 >>> n3, 0);
        }
        return a.unsignedDivModHelper(l1, h1, l2, h2, 1);
    }

    @com.oracle.svm.aotjs.annotation.a
    @JS(value="return a >>> 0;")
    private static native double asUInt(int var0);

    private static double asUnsignedSafeDouble(int low, int high) {
        return (double)high * 4.294967296E9 + a.asUInt(low);
    }

    private static a modUnsignedInternal(int l1, int h1, int l2, int h2) {
        if (a.isUnsignedSafeDouble(h1)) {
            if (a.isUnsignedSafeDouble(h2)) {
                double d2 = a.asUnsignedSafeDouble(l1, h1);
                double d3 = a.asUnsignedSafeDouble(l2, h2);
                double d4 = d2 % d3;
                return a.fromUnsignedSafeDouble(d4);
            }
            return a.fromTwoInt(l1, h1);
        }
        if (h2 == 0 && a.isPowerOfTwoIKnowItsNotZero(l2)) {
            return a.fromTwoInt(l1 & l2 - 1, 0);
        }
        if (l2 == 0 && a.isPowerOfTwoIKnowItsNotZero(h2)) {
            return a.fromTwoInt(l1, h1 & h2 - 1);
        }
        return a.unsignedDivModHelper(l1, h1, l2, h2, 0);
    }

    private static a unsignedDivModHelper(int l1, int h1, int l2, int h2, int mode) {
        int n2;
        a a2 = a.slFromNum(a.fromTwoInt(l2, h2), n2);
        int n3 = a2.low;
        int n4 = a2.high;
        int n5 = l1;
        int n6 = h1;
        int n7 = 0;
        int n8 = 0;
        for (n2 = a.numberOfLeadingZeroes(l2, h2) - a.numberOfLeadingZeroes(l1, h1); n2 >= 0 && (n6 & 0xFFE00000) != 0; --n2) {
            a a3;
            if (a.unsignedGE(n5, n6, n3, n4)) {
                a3 = a.sub(a.fromTwoInt(n5, n6), a.fromTwoInt(n3, n4));
                n5 = a3.low;
                n6 = a3.high;
                if (n2 < 32) {
                    n7 |= 1 << n2;
                } else {
                    n8 |= 1 << n2 - 32;
                }
            }
            a3 = a.usrFromNum(a.fromTwoInt(n3, n4), 1);
            n3 = a3.low;
            n4 = a3.high;
        }
        if (a.unsignedGE(n5, n6, l2, h2)) {
            double d2 = a.toNumber(a.fromTwoInt(n5, n6));
            double d3 = a.toNumber(a.fromTwoInt(l2, h2));
            if (mode == 1) {
                a a4 = a.fromUnsignedSafeDouble(d2 / d3);
                a a5 = a.addInternal(n7, n8, a4.low, a4.high);
                n7 = a5.low;
                n8 = a5.high;
            }
            if (mode == 0) {
                double d4 = d2 % d3;
                a a6 = a.fromUnsignedSafeDouble(d4);
                n5 = a6.low;
                n6 = a6.high;
            }
        }
        if (mode == 1) {
            return a.fromTwoInt(n7, n8);
        }
        return a.fromTwoInt(n5, n6);
    }

    private static a slInternal(int l1, int h1, int l2) {
        int n2 = l2 & 0x3F;
        if (n2 == 0) {
            return new a(l1, h1);
        }
        if (n2 >= 32) {
            int n3 = l1 << n2 - 32;
            return a.fromTwoInt(0, n3);
        }
        int n4 = l1 >>> 32 - n2;
        return a.fromTwoInt(l1 << n2, n4 | h1 << n2);
    }

    private static a srInternal(int l1, int h1, int l2) {
        int n2 = l2 & 0x3F;
        if (n2 == 0) {
            return a.fromTwoInt(l1, h1);
        }
        if (n2 >= 32) {
            return a.fromTwoInt(h1 >> n2 - 32, h1 >= 0 ? 0 : -1);
        }
        int n3 = h1 << 32 - n2;
        return a.fromTwoInt(l1 >>> n2 | n3, h1 >> n2);
    }

    private static a usrInternal(int l1, int h1, int l2) {
        int n2 = l2 & 0x3F;
        if (n2 == 0) {
            return a.fromTwoInt(l1, h1);
        }
        if (n2 == 32) {
            return a.fromTwoInt(h1, 0);
        }
        if (n2 >= 32) {
            return a.fromTwoInt(h1 >>> n2 - 32, 0);
        }
        int n3 = h1 << 32 - n2;
        return a.fromTwoInt(l1 >>> n2 | n3, h1 >>> n2);
    }

    private static a andInternal(int l1, int h1, int l2, int h2) {
        return a.fromTwoInt(l1 & l2, h1 & h2);
    }

    private static a orInternal(int l1, int h1, int l2, int h2) {
        return a.fromTwoInt(l1 | l2, h1 | h2);
    }

    private static a xorInternal(int l1, int h1, int l2, int h2) {
        return a.fromTwoInt(l1 ^ l2, h1 ^ h2);
    }

    private static a notInternal(int l1, int h1) {
        return a.fromTwoInt(~l1, ~h1);
    }

    private static a negateInternal(int low, int high) {
        return a.fromTwoInt(-low, low != 0 ? ~high : -high);
    }

    private static boolean equalInternal(int l1, int h1, int l2, int h2) {
        return l1 == l2 && h1 == h2;
    }

    private static boolean testInternal(int l1, int h1, int l2, int h2) {
        return (l1 & l2) == 0 && (h1 & h2) == 0;
    }

    public static a add(a left, a right) {
        return a.addInternal(left.low, left.high, right.low, right.high);
    }

    public static a sub(a left, a right) {
        return a.subInternal(left.low, left.high, right.low, right.high);
    }

    public static a mul(a left, a right) {
        return a.mulInternal(left.low, left.high, right.low, right.high);
    }

    public static a div(a left, a right) {
        return a.divInternal(left.low, left.high, right.low, right.high);
    }

    public static a and(a left, a right) {
        return a.andInternal(left.low, left.high, right.low, right.high);
    }

    public static a or(a left, a right) {
        return a.orInternal(left.low, left.high, right.low, right.high);
    }

    public static a xor(a left, a right) {
        return a.xorInternal(left.low, left.high, right.low, right.high);
    }

    public static a abs(a x2) {
        return a.absInternal(x2.low, x2.high);
    }

    public static a not(a left) {
        return a.notInternal(left.low, left.high);
    }

    public static a mod(a left, a right) {
        return a.modInternal(left.low, left.high, right.low, right.high);
    }

    public static a sl(a left, a right) {
        return a.slInternal(left.low, left.high, right.low);
    }

    public static a sr(a left, a right) {
        return a.srInternal(left.low, left.high, right.low);
    }

    public static a usr(a left, a right) {
        return a.usrInternal(left.low, left.high, right.low);
    }

    public static a slFromNum(a left, int num) {
        return a.slInternal(left.low, left.high, num);
    }

    public static a srFromNum(a left, int num) {
        return a.srInternal(left.low, left.high, num);
    }

    public static a usrFromNum(a left, int num) {
        return a.usrInternal(left.low, left.high, num);
    }

    public static a negate(a a2) {
        return a.negateInternal(a2.low, a2.high);
    }

    public static boolean equal(a l2, a r2) {
        return a.equalInternal(l2.low, l2.high, r2.low, r2.high);
    }

    public static boolean lessThan(a l2, a r2) {
        if (l2.high == r2.high) {
            return (l2.low ^ Integer.MIN_VALUE) < (r2.low ^ Integer.MIN_VALUE);
        }
        return l2.high < r2.high;
    }

    public static boolean belowThan(a l2, a r2) {
        if (l2.high == r2.high) {
            return (l2.low ^ Integer.MIN_VALUE) < (r2.low ^ Integer.MIN_VALUE);
        }
        return (l2.high ^ Integer.MIN_VALUE) < (r2.high ^ Integer.MIN_VALUE);
    }

    public static boolean test(a l2, a r2) {
        return a.testInternal(l2.low, l2.high, r2.low, r2.high);
    }

    private static boolean unsignedGE(int l1, int h1, int l2, int h2) {
        if (h1 == h2) {
            return (l1 ^ Integer.MIN_VALUE) >= (l2 ^ Integer.MIN_VALUE);
        }
        return (h1 ^ Integer.MIN_VALUE) >= (h2 ^ Integer.MIN_VALUE);
    }

    private static int numberOfLeadingZeroes(int low, int high) {
        if (high != 0) {
            return a.numberOfLeadingZeroesInt(high);
        }
        return a.numberOfLeadingZeroesInt(low) + 32;
    }

    private static int log2OfPowerOfTwo(int h2) {
        return 31 - a.numberOfLeadingZeroesInt(h2);
    }

    private static int numberOfLeadingZeroesInt(int k2) {
        int n2 = k2;
        if (n2 == 0) {
            return 32;
        }
        int n3 = 1;
        if (n2 >>> 16 == 0) {
            n3 += 16;
            n2 <<= 16;
        }
        if (n2 >>> 24 == 0) {
            n3 += 8;
            n2 <<= 8;
        }
        if (n2 >>> 28 == 0) {
            n3 += 4;
            n2 <<= 4;
        }
        if (n2 >>> 30 == 0) {
            n3 += 2;
            n2 <<= 2;
        }
        return n3 -= n2 >>> 31;
    }

    private static boolean isPowerOfTwoIKnowItsNotZero(int a2) {
        return (a2 & a2 - 1) == 0;
    }

    private static boolean isUnsignedSafeDouble(int h1) {
        return (h1 & 0xFFE00000) == 0;
    }

    public static a fromTwoInt(int low, int high) {
        return new a(low, high);
    }

    public static a fromZeroExtend(int a2) {
        return new a(a2, 0);
    }

    public static int lowBits(a a2) {
        return a2.low;
    }

    public static int highBits(a a2) {
        return a2.high;
    }

    public static int compare(a a2, a b2) {
        if (a2.high == b2.high) {
            if (a2.low == b2.low) {
                return 0;
            }
            if ((a2.low ^ Integer.MIN_VALUE) < (b2.low ^ Integer.MIN_VALUE)) {
                return -1;
            }
            return 1;
        }
        if (a2.high < b2.high) {
            return -1;
        }
        return 1;
    }

    public static int compareUnsigned(a a2, a b2) {
        if (a2.high == b2.high) {
            if (a2.low == b2.low) {
                return 0;
            }
            if ((a2.low ^ Integer.MIN_VALUE) < (b2.low ^ Integer.MIN_VALUE)) {
                return -1;
            }
            return 1;
        }
        if ((a2.high ^ Integer.MIN_VALUE) < (b2.high ^ Integer.MIN_VALUE)) {
            return -1;
        }
        return 1;
    }

    public static double toNumber(a a2) {
        return a.asUnsignedSafeDouble(a2.low, a2.high);
    }
}

