/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.debugentry.StringEntry;
import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.elf.dwarf.DwarfSectionImpl;
import com.oracle.objectfile.elf.dwarf.constants.DwarfSectionName;
import jdk.graal.compiler.debug.DebugContext;

public class DwarfStrSectionImpl
extends DwarfSectionImpl {
    public DwarfStrSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections, DwarfSectionName.DW_STR_SECTION, DwarfSectionName.DW_INFO_SECTION);
    }

    @Override
    public void createContent() {
        assert (!this.contentByteArrayCreated());
        int pos = 0;
        for (StringEntry stringEntry : this.dwarfSections.getStringTable()) {
            if (!stringEntry.isAddToStrSection()) continue;
            stringEntry.setOffset(pos);
            String string = stringEntry.getString();
            pos += DwarfStrSectionImpl.countUTF8Bytes(string) + 1;
        }
        byte[] buffer = new byte[pos];
        super.setContent(buffer);
    }

    @Override
    public void writeContent(DebugContext context) {
        assert (this.contentByteArrayCreated());
        byte[] buffer = this.getContent();
        int size = buffer.length;
        int pos = 0;
        this.enableLog(context, pos);
        this.verboseLog(context, " [0x%08x] DEBUG_STR", pos);
        for (StringEntry stringEntry : this.dwarfSections.getStringTable()) {
            if (!stringEntry.isAddToStrSection()) continue;
            assert (stringEntry.getOffset() == pos);
            String string = stringEntry.getString();
            pos = this.writeUTF8StringBytes(string, buffer, pos);
            this.verboseLog(context, " [0x%08x] string = %s", pos, string);
        }
        assert (pos == size);
    }
}

