/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.loaders;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.enterprise.profiling.framework.InstrumentationData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class ArrayBackedStorage
extends InstrumentationData.Storage {
    public static final int INITIAL_DATA_SIZE = 1000;
    private final Map<Integer, Long> monitorTypeProfiles = new HashMap<Integer, Long>();
    private long[] data = new long[1000];
    private int totalComponentCount = 1;

    public long readTotalMonitorCount(int n2) {
        return this.monitorTypeProfiles.getOrDefault(n2, 0L);
    }

    @Override
    protected int readInt(long l2, int n2, int n3) {
        throw new IllegalStateException("Loaded profiles only deal with longs for now.");
    }

    public void sideEffectFreeWriteMonitorCount(int n2, long l2) {
        this.monitorTypeProfiles.put(n2, l2);
    }

    @Override
    protected long computeCountersMemorySize() {
        throw new UnsupportedOperationException("This operation is only needed during instrumentation.");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public InstrumentationData.CounterWordSize counterWordSize() {
        return InstrumentationData.CounterWordSize.Bits64;
    }

    @Override
    protected int stripsPerCounter() {
        return 1;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long stripID() {
        return 0L;
    }

    @Override
    public int reserveUniqueCounterIDSlots(int n2) {
        int n3 = this.totalComponentCount;
        this.ensureSize(n2);
        return n3;
    }

    private void ensureSize(int n2) {
        if (this.totalComponentCount + n2 > this.data.length) {
            this.data = Arrays.copyOf(this.data, this.data.length * 2);
        }
        this.totalComponentCount += n2;
    }

    @Override
    protected long readLong(long l2, int n2, int n3) {
        if (n2 == 0) {
            return this.readTotalMonitorCount(n3 / this.counterWordSize().byteCount());
        }
        int n4 = n2 + n3 / this.counterWordSize().byteCount();
        if (n4 >= this.totalComponentCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[n4];
    }

    @Override
    protected boolean casInt(long l2, int n2, int n3, int n4, int n5) {
        throw new IllegalStateException("Loaded profiles only deal with longs for now.");
    }

    @Override
    protected void sideEffectFreeWriteLong(long l2, int n2, int n3, long l3) {
        assert (n3 % this.counterWordSize().byteCount() == 0) : "Unaligned byte offset used in PGO";
        if (n2 == 0) {
            this.sideEffectFreeWriteMonitorCount(n3 / this.counterWordSize().byteCount(), l3);
            return;
        }
        int n4 = n2 + n3 / this.counterWordSize().byteCount();
        if (n4 >= this.totalComponentCount) {
            throw new IndexOutOfBoundsException();
        }
        this.data[n4] = l3;
    }

    @Override
    protected void sideEffectFreeWriteInt(long l2, int n2, int n3, int n4) {
        throw new IllegalStateException();
    }

    @Override
    protected void reset() {
        this.data = new long[1000];
        this.monitorTypeProfiles.clear();
        this.totalComponentCount = 1;
    }
}

