/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.gc.g1;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.VMOperationInfo;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.thread.NativeVMOperation;
import com.oracle.svm.core.thread.NativeVMOperationData;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.enterprise.gc.g1.bv;
import com.oracle.svm.enterprise.gc.g1.bw;
import com.oracle.svm.enterprise.gc.g1.m;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.word.PointerBase;

public class G1VMOperations {
    private static final b ox = new b();
    private static final a oy = new a(VMOperationInfos.get(a.class, (String)"Collect for allocation", (VMOperation.SystemEffect)VMOperation.SystemEffect.SAFEPOINT), true);
    private static final a oz = new a(VMOperationInfos.get(a.class, (String)"Pause remark", (VMOperation.SystemEffect)VMOperation.SystemEffect.SAFEPOINT), true);
    private static final a oA = new a(VMOperationInfos.get(a.class, (String)"Pause cleanup", (VMOperation.SystemEffect)VMOperation.SystemEffect.SAFEPOINT), true);
    private static final a oB = new a(VMOperationInfos.get(a.class, (String)"Collect full", (VMOperation.SystemEffect)VMOperation.SystemEffect.SAFEPOINT), true);
    private static final a oC = new a(VMOperationInfos.get(a.class, (String)"Try init concurrent mark", (VMOperation.SystemEffect)VMOperation.SystemEffect.SAFEPOINT), true);
    private static final a oD = new a(VMOperationInfos.get(a.class, (String)"Verify heap", (VMOperation.SystemEffect)VMOperation.SystemEffect.SAFEPOINT), false);
    public final CEntryPointLiteral<CFunctionPointer> oE = CEntryPointLiteral.create(G1VMOperations.class, (String)"collectForAllocation", (Class[])new Class[]{PointerBase.class, IsolateThread.class, G1VMOperationData.class, G1VMOperationWrapperData.class});
    public final CEntryPointLiteral<CFunctionPointer> oF = CEntryPointLiteral.create(G1VMOperations.class, (String)"executePauseRemark", (Class[])new Class[]{PointerBase.class, IsolateThread.class, G1VMOperationData.class, G1VMOperationWrapperData.class});
    public final CEntryPointLiteral<CFunctionPointer> oG = CEntryPointLiteral.create(G1VMOperations.class, (String)"executePauseCleanup", (Class[])new Class[]{PointerBase.class, IsolateThread.class, G1VMOperationData.class, G1VMOperationWrapperData.class});
    public final CEntryPointLiteral<CFunctionPointer> oH = CEntryPointLiteral.create(G1VMOperations.class, (String)"collectFull", (Class[])new Class[]{PointerBase.class, IsolateThread.class, G1VMOperationData.class, G1VMOperationWrapperData.class});
    public final CEntryPointLiteral<CFunctionPointer> oI = CEntryPointLiteral.create(G1VMOperations.class, (String)"verifyHeap", (Class[])new Class[]{PointerBase.class, IsolateThread.class, G1VMOperationData.class, G1VMOperationWrapperData.class});
    public final CEntryPointLiteral<CFunctionPointer> oJ = CEntryPointLiteral.create(G1VMOperations.class, (String)"tryInitiateConcMark", (Class[])new Class[]{PointerBase.class, IsolateThread.class, G1VMOperationData.class, G1VMOperationWrapperData.class});
    public final CEntryPointLiteral<CFunctionPointer> oK = CEntryPointLiteral.create(G1VMOperations.class, (String)"updateVMOperationExecutionStatus", (Class[])new Class[]{PointerBase.class, IsolateThread.class, G1VMOperationWrapperData.class, Integer.TYPE});
    public final CEntryPointLiteral<CFunctionPointer> oL = CEntryPointLiteral.create(G1VMOperations.class, (String)"waitForVMOperationExecutionStatus", (Class[])new Class[]{PointerBase.class, IsolateThread.class, G1VMOperationWrapperData.class, Integer.TYPE});
    public final CEntryPointLiteral<CFunctionPointer> oM = CEntryPointLiteral.create(G1VMOperations.class, (String)"isVMOperationFinished", (Class[])new Class[]{PointerBase.class, IsolateThread.class, G1VMOperationWrapperData.class});

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public G1VMOperations() {
    }

    @Uninterruptible(reason="Can be called from a non-Java thread.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static void collectForAllocation(PointerBase pointerBase, IsolateThread isolateThread, G1VMOperationData g1VMOperationData, G1VMOperationWrapperData g1VMOperationWrapperData) {
        G1VMOperations.a(oy, g1VMOperationData, g1VMOperationWrapperData);
    }

    @Uninterruptible(reason="Can be called from a non-Java thread.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static void executePauseRemark(PointerBase pointerBase, IsolateThread isolateThread, G1VMOperationData g1VMOperationData, G1VMOperationWrapperData g1VMOperationWrapperData) {
        G1VMOperations.a(oz, g1VMOperationData, g1VMOperationWrapperData);
    }

    @Uninterruptible(reason="Can be called from a non-Java thread.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static void executePauseCleanup(PointerBase pointerBase, IsolateThread isolateThread, G1VMOperationData g1VMOperationData, G1VMOperationWrapperData g1VMOperationWrapperData) {
        G1VMOperations.a(oA, g1VMOperationData, g1VMOperationWrapperData);
    }

    @Uninterruptible(reason="Can be called from a non-Java thread.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static void collectFull(PointerBase pointerBase, IsolateThread isolateThread, G1VMOperationData g1VMOperationData, G1VMOperationWrapperData g1VMOperationWrapperData) {
        G1VMOperations.a(oB, g1VMOperationData, g1VMOperationWrapperData);
    }

    @Uninterruptible(reason="Can be called from a non-Java thread.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static void verifyHeap(PointerBase pointerBase, IsolateThread isolateThread, G1VMOperationData g1VMOperationData, G1VMOperationWrapperData g1VMOperationWrapperData) {
        G1VMOperations.a(oD, g1VMOperationData, g1VMOperationWrapperData);
    }

    @Uninterruptible(reason="Can be called from a non-Java thread.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static void tryInitiateConcMark(PointerBase pointerBase, IsolateThread isolateThread, G1VMOperationData g1VMOperationData, G1VMOperationWrapperData g1VMOperationWrapperData) {
        G1VMOperations.a(oC, g1VMOperationData, g1VMOperationWrapperData);
    }

    @Uninterruptible(reason="Can be called from a non-Java thread.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static void updateVMOperationExecutionStatus(PointerBase pointerBase, IsolateThread isolateThread, G1VMOperationWrapperData g1VMOperationWrapperData, int n2) {
        b.a(g1VMOperationWrapperData, n2);
    }

    @Uninterruptible(reason="Can be called from a non-Java thread.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static void waitForVMOperationExecutionStatus(PointerBase pointerBase, IsolateThread isolateThread, G1VMOperationWrapperData g1VMOperationWrapperData, int n2) {
        b.b(g1VMOperationWrapperData, n2);
    }

    @Uninterruptible(reason="Can be called from a non-Java thread.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static boolean isVMOperationFinished(PointerBase pointerBase, IsolateThread isolateThread, G1VMOperationWrapperData g1VMOperationWrapperData) {
        return g1VMOperationWrapperData.getFinished();
    }

    @Uninterruptible(reason="Can be called from a non-Java thread.")
    private static void a(a a2, G1VMOperationData g1VMOperationData, G1VMOperationWrapperData g1VMOperationWrapperData) {
        g1VMOperationData.setNativeVMOperation(a2);
        if (VMOperationControl.isDedicatedVMOperationThread()) {
            Safepoint.transitionVMToJava((boolean)false);
            G1VMOperations.a(a2, g1VMOperationData);
            Safepoint.transitionJavaToVM();
        } else {
            g1VMOperationWrapperData.setNativeVMOperation(ox);
            g1VMOperationWrapperData.setG1VMOperationData(g1VMOperationData);
            ox.enqueueFromNonJavaThread(g1VMOperationWrapperData);
        }
    }

    @Uninterruptible(reason="Bridges between uninterruptible and interruptible code.", calleeMustBe=false)
    private static void a(a a2, G1VMOperationData g1VMOperationData) {
        assert (VMThreads.StatusSupport.isStatusJava()) : "Thread must be in Java state to execute interruptible code";
        assert (VMOperationControl.isDedicatedVMOperationThread());
        if (!a2.a(g1VMOperationData)) {
            return;
        }
        assert (a2.getCausesSafepoint());
        a2.enqueue(g1VMOperationData);
        a2.b(g1VMOperationData);
    }

    @RawStructure
    public static interface G1VMOperationData
    extends NativeVMOperationData {
    }

    @RawStructure
    public static interface G1VMOperationWrapperData
    extends NativeVMOperationData {
        @RawField
        public int getExecutionStatus();

        @RawField
        public void setExecutionStatus(int var1);

        @RawField
        public G1VMOperationData getG1VMOperationData();

        @RawField
        public void setG1VMOperationData(G1VMOperationData var1);
    }

    private static class a
    extends NativeVMOperation {
        private final boolean oN;

        protected a(VMOperationInfo vMOperationInfo, boolean bl2) {
            super(vMOperationInfo);
            this.oN = bl2;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean isGC() {
            return this.oN;
        }

        public boolean a(NativeVMOperationData nativeVMOperationData) {
            return com.oracle.svm.enterprise.gc.g1.nativelib.b.executeVMOperationPrologue((G1VMOperationData)nativeVMOperationData);
        }

        protected void operate(NativeVMOperationData nativeVMOperationData) {
            ((m)ImageSingletons.lookup(m.class)).q();
            com.oracle.svm.enterprise.gc.g1.nativelib.b.executeVMOperationMain((G1VMOperationData)nativeVMOperationData);
        }

        public void b(NativeVMOperationData nativeVMOperationData) {
            com.oracle.svm.enterprise.gc.g1.nativelib.b.executeVMOperationEpilogue((G1VMOperationData)nativeVMOperationData);
        }
    }

    private static class b
    extends NativeVMOperation {
        private static final int oO = 0;
        private static final int oP = 1;
        private static final int oQ = 2;
        private static final int oR = 3;
        private static final int oS = 4;
        private static final int oT = 5;
        private static final VMMutex oU = new VMMutex("g1ExecutionStatus");
        private static final VMCondition oV = new VMCondition(oU);

        protected b() {
            super(VMOperationInfos.get(b.class, (String)"G1 wrapper", (VMOperation.SystemEffect)VMOperation.SystemEffect.NONE));
        }

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Used to implement GC functionality.")
        protected void operate(NativeVMOperationData nativeVMOperationData) {
            assert (ThreadingSupportImpl.isRecurringCallbackPaused());
            b.a((G1VMOperationWrapperData)nativeVMOperationData);
        }

        private static void a(G1VMOperationWrapperData g1VMOperationWrapperData) {
            assert (g1VMOperationWrapperData.getExecutionStatus() == 0);
            assert (!VMOperationControl.isDedicatedVMOperationThread((IsolateThread)g1VMOperationWrapperData.getQueuingThread()));
            assert (!VMOperation.isInProgressAtSafepoint()) : "every G1 operation that needs this kind of synchronization must start its own separate safepoint";
            b.a(g1VMOperationWrapperData, 1);
            b.b(g1VMOperationWrapperData, 2);
            if (g1VMOperationWrapperData.getExecutionStatus() != 3) {
                assert (g1VMOperationWrapperData.getExecutionStatus() == 2);
                G1VMOperationData g1VMOperationData = g1VMOperationWrapperData.getG1VMOperationData();
                a a2 = (a)g1VMOperationData.getNativeVMOperation();
                assert (a2.getCausesSafepoint());
                a2.enqueue(g1VMOperationData);
                b.a(g1VMOperationWrapperData, 4);
                b.b(g1VMOperationWrapperData, 5);
            }
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        static void a(G1VMOperationWrapperData g1VMOperationWrapperData, int n2) {
            oU.lockNoTransitionUnspecifiedOwner();
            try {
                g1VMOperationWrapperData.setExecutionStatus(n2);
                oV.broadcast();
            }
            finally {
                oU.unlockNoTransitionUnspecifiedOwner();
            }
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        static void b(G1VMOperationWrapperData g1VMOperationWrapperData, int n2) {
            oU.lockNoTransitionUnspecifiedOwner();
            try {
                while (g1VMOperationWrapperData.getExecutionStatus() < n2) {
                    oV.blockNoTransitionUnspecifiedOwner();
                }
            }
            finally {
                oU.unlockNoTransitionUnspecifiedOwner();
            }
        }
    }
}

