/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.stringformat;

import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import java.math.BigInteger;
import java.util.Formattable;
import java.util.Formatter;
import java.util.IllegalFormatCodePointException;
import java.util.IllegalFormatConversionException;
import java.util.Locale;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;

public final class a {
    static final char lZ = 'd';
    static final char ma = 'x';
    static final char mb = 'X';
    static final char mc = 'c';
    static final char md = 's';
    static final String me = "dxXcs";
    final EconomicMap<Locale, Character> mf = ImageHeapMap.create();

    static a cR() {
        return (a)ImageSingletons.lookup(a.class);
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static String format(String string, Object[] objectArray) {
        return a.a(true, null, string, objectArray);
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static String format(Locale locale, String string, Object[] objectArray) {
        return a.a(false, locale, string, objectArray);
    }

    private static String a(boolean bl2, Locale locale, String string, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = null;
        Character c2 = null;
        int n2 = string.length();
        assert (n2 >= objectArray.length);
        int n3 = 0;
        int n4 = 0;
        while (n4 < objectArray.length) {
            Object object = objectArray[n4];
            char c3 = string.charAt(n3);
            if (object == null) {
                stringBuilder.append(c3 == 'X' ? "NULL" : "null");
            } else {
                int n5 = -1;
                if (n3 + 1 < n2 && a.a(string.charAt(n3 + 1))) {
                    n5 = string.charAt(++n3) - 48;
                }
                switch (c3) {
                    case 'd': {
                        formatter = a.a(formatter, bl2, locale, stringBuilder);
                        c2 = a.a(c2, formatter);
                        a.a(bl2, locale, stringBuilder, object, c3, c2.charValue(), n5);
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        a.a(bl2, locale, stringBuilder, object, c3, '0', n5);
                        break;
                    }
                    case 'c': {
                        a.a(stringBuilder, object, Character.valueOf(c3));
                        break;
                    }
                    case 's': {
                        if (object instanceof Formattable) {
                            formatter = a.a(formatter, bl2, locale, stringBuilder);
                            ((Formattable)object).formatTo(formatter, 0, -1, -1);
                            break;
                        }
                        stringBuilder.append(object);
                        break;
                    }
                    default: {
                        throw VMError.shouldNotReachHere((String)("Illegal modifier at index " + n3 + " in " + string));
                    }
                }
            }
            ++n4;
            ++n3;
        }
        return stringBuilder.toString();
    }

    private static boolean a(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private static void a(boolean bl2, Locale locale, StringBuilder stringBuilder, Object object, char c2, char c3, int n2) {
        String string;
        boolean bl3;
        boolean bl4 = c2 == 'x' || c2 == 'X';
        boolean bl5 = bl3 = c2 == 'X';
        if (object instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)object;
            string = bl4 ? bigInteger.toString(16) : bigInteger.toString();
        } else {
            long l2;
            if (object instanceof Byte) {
                l2 = ((Byte)object).byteValue();
                if (l2 < 0L && bl4) {
                    l2 += 256L;
                }
            } else if (object instanceof Short) {
                l2 = ((Short)object).shortValue();
                if (l2 < 0L && bl4) {
                    l2 += 65536L;
                }
            } else if (object instanceof Integer) {
                l2 = ((Integer)object).intValue();
                if (l2 < 0L && bl4) {
                    l2 += 0x100000000L;
                }
            } else if (object instanceof Long) {
                l2 = (Long)object;
            } else {
                throw new IllegalFormatConversionException(c2, object.getClass());
            }
            string = bl4 ? Long.toHexString(l2) : Long.toString(l2);
        }
        if (n2 >= 0) {
            for (int i2 = string.length(); i2 < n2; ++i2) {
                stringBuilder.append(c3);
            }
        }
        if (bl3) {
            string = string.toUpperCase(bl2 ? Locale.getDefault(Locale.Category.FORMAT) : locale);
        }
        for (int i3 = 0; i3 < string.length(); ++i3) {
            char c4 = (char)(string.charAt(i3) - 48 + c3);
            stringBuilder.append(c4);
        }
    }

    private static void a(StringBuilder stringBuilder, Object object, Character c2) {
        String string;
        if (object instanceof Character) {
            string = ((Character)object).toString();
        } else {
            int n2;
            if (object instanceof Byte) {
                n2 = ((Byte)object).byteValue();
            } else if (object instanceof Short) {
                n2 = ((Short)object).shortValue();
            } else if (object instanceof Integer) {
                n2 = (Integer)object;
            } else {
                throw new IllegalFormatConversionException(c2.charValue(), object.getClass());
            }
            if (Character.isValidCodePoint(n2)) {
                string = new String(Character.toChars(n2));
            } else {
                throw new IllegalFormatCodePointException(n2);
            }
        }
        stringBuilder.append(string);
    }

    private static Formatter a(Formatter formatter, boolean bl2, Locale locale, Appendable appendable) {
        if (formatter != null) {
            return formatter;
        }
        if (bl2) {
            return new Formatter(appendable);
        }
        return new Formatter(appendable, locale);
    }

    private static Character a(Character c2, Formatter formatter) {
        if (c2 != null) {
            return c2;
        }
        Locale locale = formatter.locale();
        return a.a(locale);
    }

    static Character a(Locale locale) {
        if (locale == null) {
            return Character.valueOf('0');
        }
        Character c2 = (Character)a.cR().mf.get((Object)locale);
        if (c2 == null) {
            return Character.valueOf('0');
        }
        return c2;
    }
}

