/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.jimfs;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.jimfs.Directory;
import com.google.common.jimfs.File;
import com.google.common.jimfs.Name;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.util.Objects;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class DirectoryEntry {
    private final Directory directory;
    private final Name name;
    @NullableDecl
    private final File file;
    @NullableDecl
    DirectoryEntry next;

    DirectoryEntry(Directory directory, Name name, @NullableDecl File file) {
        this.directory = (Directory)Preconditions.checkNotNull((Object)directory);
        this.name = (Name)Preconditions.checkNotNull((Object)name);
        this.file = file;
    }

    public boolean exists() {
        return this.file != null;
    }

    public DirectoryEntry requireExists(Path pathForException) throws NoSuchFileException {
        if (!this.exists()) {
            throw new NoSuchFileException(pathForException.toString());
        }
        return this;
    }

    public DirectoryEntry requireDoesNotExist(Path pathForException) throws FileAlreadyExistsException {
        if (this.exists()) {
            throw new FileAlreadyExistsException(pathForException.toString());
        }
        return this;
    }

    public DirectoryEntry requireDirectory(Path pathForException) throws NoSuchFileException, NotDirectoryException {
        this.requireExists(pathForException);
        if (!this.file().isDirectory()) {
            throw new NotDirectoryException(pathForException.toString());
        }
        return this;
    }

    public DirectoryEntry requireSymbolicLink(Path pathForException) throws NoSuchFileException, NotLinkException {
        this.requireExists(pathForException);
        if (!this.file().isSymbolicLink()) {
            throw new NotLinkException(pathForException.toString());
        }
        return this;
    }

    public Directory directory() {
        return this.directory;
    }

    public Name name() {
        return this.name;
    }

    public File file() {
        Preconditions.checkState((boolean)this.exists());
        return this.file;
    }

    @NullableDecl
    public File fileOrNull() {
        return this.file;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DirectoryEntry) {
            DirectoryEntry other = (DirectoryEntry)obj;
            return this.directory.equals(other.directory) && this.name.equals(other.name) && Objects.equals(this.file, other.file);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.directory, this.name, this.file);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("directory", (Object)this.directory).add("name", (Object)this.name).add("file", (Object)this.file).toString();
    }
}

