/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.tools.asn1.Asn1;
import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import com.oracle.jipher.internal.tools.asn1.Asn1DecodeException;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.List;
import javax.crypto.spec.PBEParameterSpec;

public final class PbeParameters
extends AlgorithmParametersSpi {
    private PBEParameterSpec pbeSpec;

    @Override
    protected byte[] engineGetEncoded() {
        byte[] salt = this.pbeSpec.getSalt();
        int iterationCount = this.pbeSpec.getIterationCount();
        Asn1BerValue pbeParams = Asn1.newSequence(Asn1.newOctetString(salt), Asn1.newInteger(iterationCount));
        return pbeParams.encodeDerOctets();
    }

    @Override
    protected byte[] engineGetEncoded(String format) {
        return this.engineGetEncoded();
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (paramSpec != null && paramSpec.isAssignableFrom(PBEParameterSpec.class)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(this.pbeSpec));
        }
        throw new InvalidParameterSpecException("Expected ParameterSpec class to be assignable from PBEParameterSpec");
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        try {
            Asn1BerValue pbeParamsSeq = Asn1.decodeOne(params);
            Util.assertAllUniversal(pbeParamsSeq);
            List<Asn1BerValue> pbeParams = pbeParamsSeq.count(2).sequence();
            byte[] salt = pbeParams.get(0).getOctetString();
            if (salt.length == 0) {
                throw new Asn1DecodeException("Invalid salt parameter");
            }
            int iterationCount = pbeParams.get(1).getInteger().intValueExact();
            if (iterationCount < 1) {
                throw new Asn1DecodeException("Invalid iterationCount parameter");
            }
            this.pbeSpec = new PBEParameterSpec(salt, iterationCount);
        }
        catch (Asn1DecodeException | ArithmeticException ex) {
            throw new IOException("Invalid PBE parameters", ex);
        }
    }

    @Override
    protected void engineInit(byte[] params, String format) throws IOException {
        this.engineInit(params);
    }

    @Override
    protected String engineToString() {
        StringBuilder sb = new StringBuilder("PBE Parameters");
        if (this.pbeSpec != null) {
            sb.append(" [ salt=").append(Util.bytesToHex(this.pbeSpec.getSalt()));
            sb.append(", iterationCount=").append(this.pbeSpec.getIterationCount());
            sb.append(" ]");
        }
        return sb.toString();
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.pbeSpec = (PBEParameterSpec)paramSpec;
    }
}

