/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.spi.CipherAlg;
import com.oracle.jipher.internal.tools.asn1.Asn1;
import com.oracle.jipher.internal.tools.asn1.Asn1DecodeException;
import com.oracle.jipher.internal.tools.asn1.UniversalTag;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public abstract class CipherParameters
extends AlgorithmParametersSpi {
    private IvParameterSpec ivSpec;
    private final CipherAlg alg;

    CipherParameters(CipherAlg alg) {
        this.alg = alg;
    }

    @Override
    protected byte[] engineGetEncoded() {
        return Asn1.newOctetString(this.ivSpec.getIV()).encodeDerOctets();
    }

    @Override
    protected byte[] engineGetEncoded(String format) {
        return this.engineGetEncoded();
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (paramSpec != null && paramSpec.isAssignableFrom(IvParameterSpec.class)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(this.ivSpec));
        }
        throw new InvalidParameterSpecException("Expected ParameterSpec class to be assignable from IvParameterSpec");
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        byte[] iv;
        try {
            iv = Asn1.decodeOne(params).tag(UniversalTag.OCTET_STRING).getOctetString();
        }
        catch (Asn1DecodeException ex) {
            throw new IOException("Invalid IV encoding", ex);
        }
        if (iv.length != this.alg.getBlockSize()) {
            throw new IOException("Invalid IV encoding (length)");
        }
        this.ivSpec = new IvParameterSpec(iv);
    }

    @Override
    protected void engineInit(byte[] params, String format) throws IOException {
        this.engineInit(params);
    }

    @Override
    protected String engineToString() {
        return this.alg.getName() + " Parameters [ iv = " + Util.bytesToHex(this.ivSpec.getIV()) + "]";
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException("Invalid parameter spec, expected IvParameterSpec");
        }
        if (((IvParameterSpec)paramSpec).getIV().length != this.alg.getBlockSize()) {
            throw new InvalidParameterSpecException("Invalid IV length");
        }
        this.ivSpec = (IvParameterSpec)paramSpec;
    }

    public static final class DESedeParameters
    extends CipherParameters {
        public DESedeParameters() {
            super(new CipherAlg.DesEde());
        }
    }

    public static final class AesParameters
    extends CipherParameters {
        public AesParameters() {
            super(new CipherAlg.AES());
        }
    }
}

