/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.openssl;

import com.oracle.jipher.internal.common.Debug;
import com.oracle.jipher.internal.loader.LibraryLoader;
import com.oracle.jipher.internal.loader.LibraryLoaderContext;
import com.oracle.jipher.internal.openssl.JniOpenSsl;
import com.oracle.jipher.internal.openssl.OpenSsl;
import com.oracle.jipher.internal.openssl.OpenSslDebug;
import java.security.ProviderException;

final class OsslFactory {
    private static OpenSsl instance;
    private static Debug DEBUG;
    private static ProviderException loadingException;

    OsslFactory() {
    }

    static void setInstance(OpenSsl ossl) {
        instance = ossl;
    }

    static OpenSsl get() {
        if (loadingException != null) {
            throw loadingException;
        }
        return instance;
    }

    static boolean isAvailable() {
        return loadingException == null;
    }

    static ProviderException loadingException() {
        return loadingException;
    }

    static {
        DEBUG = Debug.getInstance("jipher");
        LibraryLoader loader = LibraryLoader.getInstance(new LibraryLoaderContext(new JniOpenSsl()));
        loader.cleanTempDirs();
        try {
            OpenSsl jossl = loader.load();
            DEBUG.println(jossl.configInfo());
            instance = Debug.isEnabled("jni") ? OpenSslDebug.newProxyInstance(jossl) : jossl;
        }
        catch (ProviderException exc) {
            loadingException = exc;
        }
        catch (Exception exc) {
            loadingException = new ProviderException(exc);
        }
    }
}

