// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: DebugOptions.java
package org.graalvm.compiler.debug;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionStability;

public class DebugOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "AggregatedMetricsFile": {
            return OptionDescriptor.create(
                /*name*/ "AggregatedMetricsFile",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "File to which aggregated metrics are dumped at shutdown. A CSV format is used if the file ends with .csv otherwise a more human readable format is used. If not specified, metrics are dumped to the console.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "AggregatedMetricsFile",
                /*option*/ DebugOptions.AggregatedMetricsFile,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BootstrapInitializeOnly": {
            return OptionDescriptor.create(
                /*name*/ "BootstrapInitializeOnly",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Do not compile anything on bootstrap but just initialize the compiler.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "BootstrapInitializeOnly",
                /*option*/ DebugOptions.BootstrapInitializeOnly,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CanonicalGraphStringsCheckConstants": {
            return OptionDescriptor.create(
                /*name*/ "CanonicalGraphStringsCheckConstants",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Exclude virtual nodes when dumping canonical text for graphs.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "CanonicalGraphStringsCheckConstants",
                /*option*/ DebugOptions.CanonicalGraphStringsCheckConstants,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CanonicalGraphStringsExcludeVirtuals": {
            return OptionDescriptor.create(
                /*name*/ "CanonicalGraphStringsExcludeVirtuals",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Exclude virtual nodes when dumping canonical text for graphs.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "CanonicalGraphStringsExcludeVirtuals",
                /*option*/ DebugOptions.CanonicalGraphStringsExcludeVirtuals,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CanonicalGraphStringsRemoveIdentities": {
            return OptionDescriptor.create(
                /*name*/ "CanonicalGraphStringsRemoveIdentities",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Attempts to remove object identity hashes when dumping canonical text for graphs.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "CanonicalGraphStringsRemoveIdentities",
                /*option*/ DebugOptions.CanonicalGraphStringsRemoveIdentities,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ClearMetricsAfterBootstrap": {
            return OptionDescriptor.create(
                /*name*/ "ClearMetricsAfterBootstrap",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Clear the debug metrics after bootstrap.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "ClearMetricsAfterBootstrap",
                /*option*/ DebugOptions.ClearMetricsAfterBootstrap,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Count": {
            return OptionDescriptor.create(
                /*name*/ "Count",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Pattern for specifying scopes in which counters are enabled. See the Dump option for the pattern syntax. An empty value enables all counters unconditionally.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "Count",
                /*option*/ DebugOptions.Count,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Counters": {
            return OptionDescriptor.create(
                /*name*/ "Counters",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Comma separated names of counters that are enabled irrespective of the value for Count option. An empty value enables all counters unconditionally.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "Counters",
                /*option*/ DebugOptions.Counters,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DebugStubsAndSnippets": {
            return OptionDescriptor.create(
                /*name*/ "DebugStubsAndSnippets",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable debug output for stub code generation and snippet preparation.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "DebugStubsAndSnippets",
                /*option*/ DebugOptions.DebugStubsAndSnippets,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DiagnoseDumpLevel": {
            return OptionDescriptor.create(
                /*name*/ "DiagnoseDumpLevel",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specify the dump level if CompilationFailureAction#Diagnose is used.See CompilationFailureAction for details. file:doc-files/CompilationFailureActionHelp.txt",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "DiagnoseDumpLevel",
                /*option*/ DebugOptions.DiagnoseDumpLevel,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DisableIntercept": {
            return OptionDescriptor.create(
                /*name*/ "DisableIntercept",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Disable intercepting exceptions in debug scopes.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "DisableIntercept",
                /*option*/ DebugOptions.DisableIntercept,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Dump": {
            return OptionDescriptor.create(
                /*name*/ "Dump",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Filter pattern for specifying scopes in which dumping is enabled.",
                /*extraHelp*/ new String[] {
                         "",
                         "A filter is a list of comma-separated terms of the form:",
                         " ",
                         "  <pattern>[:<level>]",
                         " ",
                         "If <pattern> contains a \"*\" or \"?\" character, it is interpreted as a glob pattern.",
                         "Otherwise, it is interpreted as a substring. If <pattern> is empty, it",
                         "matches every scope. If :<level> is omitted, it defaults to 1. The term",
                         "~<pattern> is a shorthand for <pattern>:0 to disable a debug facility for a pattern.",
                         "",
                         "The default log level is 0 (disabled). Terms with an empty pattern set",
                         "the default log level to the specified value. The last",
                         "matching term with a non-empty pattern selects the level specified. If",
                         "no term matches, the log level is the default level. A filter with no",
                         "terms matches every scope with a log level of 1.",
                         "",
                         "Examples of debug filters:",
                         "--------- ",
                         "  (empty string)",
                         "",
                         "  Matches any scope with level 1.",
                         "--------- ",
                         "  :1",
                         "",
                         "  Matches any scope with level 1.",
                         "--------- ",
                         "  *",
                         "",
                         "  Matches any scope with level 1.",
                         "--------- ",
                         "  CodeGen,CodeInstall",
                         "",
                         "  Matches scopes containing \"CodeGen\" or \"CodeInstall\", both with level 1.",
                         "--------- ",
                         "  CodeGen:2,CodeInstall:1",
                         "",
                         "  Matches scopes containing \"CodeGen\" with level 2, or \"CodeInstall\" with level 1.",
                         "---------",
                         "  Outer:2,Inner:0}",
                         "",
                         "  Matches scopes containing \"Outer\" with log level 2, or \"Inner\" with log level 0. If the scope",
                         "  name contains both patterns then the log level will be 0. This is useful for silencing subscopes.",
                         "---------",
                         "  :1,Dead:2",
                         "",
                         "  Matches scopes containing \"Dead\" with level 2, and all other scopes with level 1.",
                         "--------- ",
                         "  Dead:0,:1",
                         "",
                         "  Matches all scopes with level 1, except those containing \"Dead\".   Note that the location of",
                         "  the :1 doesn't matter since it's specifying the default log level so it's the same as",
                         "  specifying :1,Dead:0.",
                         "--------- ",
                         "  Code*",
                         "",
                         "  Matches scopes starting with \"Code\" with level 1.",
                         "--------- ",
                         "  Code,~Dead",
                         "",
                         "  Matches scopes containing \"Code\" but not \"Dead\", with level 1.",
                              },
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "Dump",
                /*option*/ DebugOptions.Dump,
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DumpOnError": {
            return OptionDescriptor.create(
                /*name*/ "DumpOnError",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Send compiler IR to dump handlers on error.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "DumpOnError",
                /*option*/ DebugOptions.DumpOnError,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DumpOnPhaseChange": {
            return OptionDescriptor.create(
                /*name*/ "DumpOnPhaseChange",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Dump a before and after graph if the named phase changes the graph.%nThe argument is substring matched against the simple name of the phase class",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "DumpOnPhaseChange",
                /*option*/ DebugOptions.DumpOnPhaseChange,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DumpPath": {
            return OptionDescriptor.create(
                /*name*/ "DumpPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "The directory where various Graal dump files are written.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "DumpPath",
                /*option*/ DebugOptions.DumpPath,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DumpingErrorsAreFatal": {
            return OptionDescriptor.create(
                /*name*/ "DumpingErrorsAreFatal",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Treat any exceptions during dumping as fatal.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "DumpingErrorsAreFatal",
                /*option*/ DebugOptions.DumpingErrorsAreFatal,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InterceptBailout": {
            return OptionDescriptor.create(
                /*name*/ "InterceptBailout",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Intercept also bailout exceptions",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "InterceptBailout",
                /*option*/ DebugOptions.InterceptBailout,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ListMetrics": {
            return OptionDescriptor.create(
                /*name*/ "ListMetrics",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Lists on the console at VM shutdown the metric names available to the Timers, Counters and MemUseTrackers options. Note that this only lists the metrics that were initialized during the VM execution and so will not include metrics for compiler code that is not executed.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "ListMetrics",
                /*option*/ DebugOptions.ListMetrics,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Log": {
            return OptionDescriptor.create(
                /*name*/ "Log",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Pattern for specifying scopes in which logging is enabled. See the Dump option for the pattern syntax.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "Log",
                /*option*/ DebugOptions.Log,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LogVerbose": {
            return OptionDescriptor.create(
                /*name*/ "LogVerbose",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable more verbose log output when available",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "LogVerbose",
                /*option*/ DebugOptions.LogVerbose,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MemUseTrackers": {
            return OptionDescriptor.create(
                /*name*/ "MemUseTrackers",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Comma separated names of memory usage trackers that are enabled irrespective of the value for TrackMemUse option. An empty value enables all memory usage trackers unconditionally.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "MemUseTrackers",
                /*option*/ DebugOptions.MemUseTrackers,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MethodFilter": {
            return OptionDescriptor.create(
                /*name*/ "MethodFilter",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Pattern for matching methods. The syntax for a pattern is:",
                /*extraHelp*/ new String[] {
                         "",
                         "  SourcePatterns = SourcePattern [\",\" SourcePatterns] .",
                         "  SourcePattern = [ \"~\" ] [ Class \".\" ] method [ \"(\" [ Parameter { \";\" Parameter } ] \")\" ] .",
                         "  Parameter = Class | \"int\" | \"long\" | \"float\" | \"double\" | \"short\" | \"char\" | \"boolean\" .",
                         "  Class = { package \".\" } class .",
                         "",
                         "Glob pattern matching (*, ?) is allowed in all parts of the source pattern.",
                         "The \"~\" prefix negates the pattern.",
                         "",
                         "Positive patterns are joined by an \"or\" operator: \"A,B\" matches anything",
                         "matched by \"A\" or \"B\". Negative patterns are joined by \"and not\": \"~A,~B\"",
                         "matches anything not matched by \"A\" and not matched by \"B\". \"A,~B,~C,D\"",
                         "matches anything matched by \"A\" or \"D\" and not matched by \"B\" and not",
                         "matched by \"C\".",
                         "",
                         "A set of patterns containing negative patterns but no positive ones contains",
                         "an implicit positive \"*\" pattern: \"~A,~B\" is equivalent to \"*,~A,~B\".",
                         "",
                         "Examples of method filters:",
                         "---------",
                         "  *",
                         "",
                         "  Matches all methods in all classes.",
                         "---------",
                         "  canonical(CanonicalizerTool;LogicNode;LogicNode)",
                         "",
                         "  Matches all methods named \"canonical\", with the first parameter of type",
                         "  \"CanonicalizerTool\", and the second and third parameters of type",
                         "  \"LogicNode\".",
                         "  The packages of the parameter types are irrelevant.",
                         "---------",
                         "  arraycopy(Object;;;;)",
                         "",
                         "  Matches all methods named \"arraycopy\", with the first parameter",
                         "  of type \"Object\", and four more parameters of any type. The",
                         "  packages of the parameter types are irrelevant.",
                         "---------",
                         "  List.set",
                         "",
                         "  Matches all methods named \"set\" in a class whose simple name is \"List\".",
                         "---------",
                         "  *List.set",
                         "",
                         "  Matches all methods named \"set\" in a class whose simple name ends with \"List\".",
                         "---------",
                         "  org.graalvm.compiler.nodes.PhiNode.*",
                         "",
                         "  Matches all methods in the class \"org.graalvm.compiler.nodes.PhiNode\".",
                         "---------",
                         "  org.graalvm.compiler.nodes.*.canonical",
                         "",
                         "  Matches all methods named \"canonical\" in classes in the package",
                         "  \"org.graalvm.compiler.nodes\".",
                         "---------",
                         "  arraycopy,toString",
                         "",
                         "  Matches all methods named \"arraycopy\" or \"toString\", meaning that ',' acts",
                         "  as an \"or\" operator.",
                         "---------",
                         "  java.util.*.*.,~java.util.*Array*.*",
                         "  java.util.*.*.,~*Array*.*",
                         "",
                         "  These patterns are equivalent and match all methods in the package",
                         "  \"java.util\" except for classes that have \"Array\" in their name.",
                         "---------",
                         "  ~java.util.*.*",
                         "",
                         "  Matches all methods in all classes in all packages except for anything in",
                         "  the \"java.util\" package.",
                              },
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "MethodFilter",
                /*option*/ DebugOptions.MethodFilter,
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MethodFilterRootOnly": {
            return OptionDescriptor.create(
                /*name*/ "MethodFilterRootOnly",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Only check MethodFilter against the root method in the context if true, otherwise check all methods",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "MethodFilterRootOnly",
                /*option*/ DebugOptions.MethodFilterRootOnly,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MetricsFile": {
            return OptionDescriptor.create(
                /*name*/ "MetricsFile",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "File to which metrics are dumped per compilation.",
                /*extraHelp*/ new String[] {
                         "A CSV format is used if the file ends with .csv otherwise a more",
                         "human readable format is used. The fields in the CSV format are:",
                         "           compilable - method being compiled",
                         "  compilable_identity - identity hash code of compilable",
                         "       compilation_nr - where this compilation lies in the ordered",
                         "                        sequence of all compilations identified by",
                         "                        compilable_identity",
                         "       compilation_id - runtime issued identifier for the compilation",
                         "          metric_name - name of metric",
                         "         metric_value - value of metric",
                              },
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "MetricsFile",
                /*option*/ DebugOptions.MetricsFile,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptimizationLog": {
            return OptionDescriptor.create(
                /*name*/ "OptimizationLog",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ org.graalvm.collections.EconomicSet.class,
                /*help*/ "Enable the structured optimization log and specify where it is printed.",
                /*extraHelp*/ new String[] {
                         "The accepted values are:",
                         "  Directory - Format the structured optimization log as JSON and print it to files in a directory.",
                         "              The directory is specified by OptimizationLogPath. If OptimizationLogPath is not set,",
                         "              the target directory is DumpPath/optimization_log.",
                         "     Stdout - Print the structured optimization log to the standard output.",
                         "       Dump - Dump optimization trees for IdealGraphVisualizer according to the PrintGraph option.",
                         "It is possible to specify multiple comma-separated values.",
                              },
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "OptimizationLog",
                /*option*/ DebugOptions.OptimizationLog,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptimizationLogPath": {
            return OptionDescriptor.create(
                /*name*/ "OptimizationLogPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Path to the directory where the optimization log is saved if OptimizationLog is set to Directory. Directories are created if they do no exist.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "OptimizationLogPath",
                /*option*/ DebugOptions.OptimizationLogPath,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintBBInfo": {
            return OptionDescriptor.create(
                /*name*/ "PrintBBInfo",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enables dumping of basic blocks relative PC and frequencies in the dump directory.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintBBInfo",
                /*option*/ DebugOptions.PrintBBInfo,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintBackendCFG": {
            return OptionDescriptor.create(
                /*name*/ "PrintBackendCFG",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable dumping scheduled HIR, LIR, register allocation and code generation info to the C1Visualizer.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintBackendCFG",
                /*option*/ DebugOptions.PrintBackendCFG,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintBlockMapping": {
            return OptionDescriptor.create(
                /*name*/ "PrintBlockMapping",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable dumping CFG built during initial BciBlockMapping",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintBlockMapping",
                /*option*/ DebugOptions.PrintBlockMapping,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintCanonicalGraphStringFlavor": {
            return OptionDescriptor.create(
                /*name*/ "PrintCanonicalGraphStringFlavor",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Choose format used when dumping canonical text for graphs: 0 gives a scheduled graph (better for spotting changes involving the schedule) while 1 gives a CFG containing expressions rooted at fixed nodes (better for spotting small structure differences)",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintCanonicalGraphStringFlavor",
                /*option*/ DebugOptions.PrintCanonicalGraphStringFlavor,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintCanonicalGraphStrings": {
            return OptionDescriptor.create(
                /*name*/ "PrintCanonicalGraphStrings",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable dumping canonical text from for graphs.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintCanonicalGraphStrings",
                /*option*/ DebugOptions.PrintCanonicalGraphStrings,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintGraph": {
            return OptionDescriptor.create(
                /*name*/ "PrintGraph",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ org.graalvm.compiler.debug.DebugOptions.PrintGraphTarget.class,
                /*help*/ "Where IdealGraphVisualizer graph dumps triggered by Dump or DumpOnError should be written.",
                /*extraHelp*/ new String[] {
                         "The accepted values are:",
                         "      File - Dump IGV graphs to the local file system (see DumpPath).",
                         "   Network - Dump IGV graphs to the network destination specified by PrintGraphHost and PrintGraphPort.",
                         "             If a network connection cannot be opened, dumping falls back to file dumping. ",
                         "   Disable - Do not dump IGV graphs.",
                              },
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintGraph",
                /*option*/ DebugOptions.PrintGraph,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintGraphFile": {
            return OptionDescriptor.create(
                /*name*/ "PrintGraphFile",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Setting to true sets PrintGraph=file, setting to false sets PrintGraph=network",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintGraphFile",
                /*option*/ DebugOptions.PrintGraphFile,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintGraphHost": {
            return OptionDescriptor.create(
                /*name*/ "PrintGraphHost",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Host part of the address to which graphs are dumped.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintGraphHost",
                /*option*/ DebugOptions.PrintGraphHost,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintGraphPort": {
            return OptionDescriptor.create(
                /*name*/ "PrintGraphPort",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Port part of the address to which graphs are dumped in binary format.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintGraphPort",
                /*option*/ DebugOptions.PrintGraphPort,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintGraphWithSchedule": {
            return OptionDescriptor.create(
                /*name*/ "PrintGraphWithSchedule",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Schedule graphs as they are dumped.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintGraphWithSchedule",
                /*option*/ DebugOptions.PrintGraphWithSchedule,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintUnmodifiedGraphs": {
            return OptionDescriptor.create(
                /*name*/ "PrintUnmodifiedGraphs",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Dump a graph even if it has not changed since it was last dumped.  Change detection is based on adding and deleting nodes or changing inputs.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "PrintUnmodifiedGraphs",
                /*option*/ DebugOptions.PrintUnmodifiedGraphs,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ShowDumpFiles": {
            return OptionDescriptor.create(
                /*name*/ "ShowDumpFiles",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print the name of each dump file path as it's created.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "ShowDumpFiles",
                /*option*/ DebugOptions.ShowDumpFiles,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Time": {
            return OptionDescriptor.create(
                /*name*/ "Time",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Pattern for specifying scopes in which timing is enabled. See the Dump option for the pattern syntax. An empty value enables all timers unconditionally.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "Time",
                /*option*/ DebugOptions.Time,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Timers": {
            return OptionDescriptor.create(
                /*name*/ "Timers",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Comma separated names of timers that are enabled irrespective of the value for Time option. An empty value enables all timers unconditionally.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "Timers",
                /*option*/ DebugOptions.Timers,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrackMemUse": {
            return OptionDescriptor.create(
                /*name*/ "TrackMemUse",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Pattern for specifying scopes in which memory use tracking is enabled. See the Dump option for the pattern syntax. An empty value enables all memory use trackers unconditionally.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "TrackMemUse",
                /*option*/ DebugOptions.TrackMemUse,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Verify": {
            return OptionDescriptor.create(
                /*name*/ "Verify",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Pattern for specifying scopes in which logging is enabled. See the Dump option for the pattern syntax.",
                /*declaringClass*/ DebugOptions.class,
                /*fieldName*/ "Verify",
                /*option*/ DebugOptions.Verify,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 42;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AggregatedMetricsFile");
                    case 1: return get("BootstrapInitializeOnly");
                    case 2: return get("CanonicalGraphStringsCheckConstants");
                    case 3: return get("CanonicalGraphStringsExcludeVirtuals");
                    case 4: return get("CanonicalGraphStringsRemoveIdentities");
                    case 5: return get("ClearMetricsAfterBootstrap");
                    case 6: return get("Count");
                    case 7: return get("Counters");
                    case 8: return get("DebugStubsAndSnippets");
                    case 9: return get("DiagnoseDumpLevel");
                    case 10: return get("DisableIntercept");
                    case 11: return get("Dump");
                    case 12: return get("DumpOnError");
                    case 13: return get("DumpOnPhaseChange");
                    case 14: return get("DumpPath");
                    case 15: return get("DumpingErrorsAreFatal");
                    case 16: return get("InterceptBailout");
                    case 17: return get("ListMetrics");
                    case 18: return get("Log");
                    case 19: return get("LogVerbose");
                    case 20: return get("MemUseTrackers");
                    case 21: return get("MethodFilter");
                    case 22: return get("MethodFilterRootOnly");
                    case 23: return get("MetricsFile");
                    case 24: return get("OptimizationLog");
                    case 25: return get("OptimizationLogPath");
                    case 26: return get("PrintBBInfo");
                    case 27: return get("PrintBackendCFG");
                    case 28: return get("PrintBlockMapping");
                    case 29: return get("PrintCanonicalGraphStringFlavor");
                    case 30: return get("PrintCanonicalGraphStrings");
                    case 31: return get("PrintGraph");
                    case 32: return get("PrintGraphFile");
                    case 33: return get("PrintGraphHost");
                    case 34: return get("PrintGraphPort");
                    case 35: return get("PrintGraphWithSchedule");
                    case 36: return get("PrintUnmodifiedGraphs");
                    case 37: return get("ShowDumpFiles");
                    case 38: return get("Time");
                    case 39: return get("Timers");
                    case 40: return get("TrackMemUse");
                    case 41: return get("Verify");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
