// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: PerfManager.java
package com.oracle.svm.core.jvmstat;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionStability;

public class PerfManager_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "PerfDataMemoryMappedFile": {
            return OptionDescriptor.create(
                /*name*/ "PerfDataMemoryMappedFile",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if the collected performance data should be written to a memory-mapped file so that it can be accessed by external tools.",
                /*declaringClass*/ PerfManager.Options.class,
                /*fieldName*/ "PerfDataMemoryMappedFile",
                /*option*/ PerfManager.Options.PerfDataMemoryMappedFile,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PerfDataMemorySize": {
            return OptionDescriptor.create(
                /*name*/ "PerfDataMemorySize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Size of performance data memory region. Will be rounded up to a multiple of the native os page size.",
                /*declaringClass*/ PerfManager.Options.class,
                /*fieldName*/ "PerfDataMemorySize",
                /*option*/ PerfManager.Options.PerfDataMemorySize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PerfDataSamplingInterval": {
            return OptionDescriptor.create(
                /*name*/ "PerfDataSamplingInterval",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Jvmstat instrumentation sampling interval (in milliseconds)",
                /*declaringClass*/ PerfManager.Options.class,
                /*fieldName*/ "PerfDataSamplingInterval",
                /*option*/ PerfManager.Options.PerfDataSamplingInterval,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PerfMaxStringConstLength": {
            return OptionDescriptor.create(
                /*name*/ "PerfMaxStringConstLength",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum PerfStringConstant string length before truncation",
                /*declaringClass*/ PerfManager.Options.class,
                /*fieldName*/ "PerfMaxStringConstLength",
                /*option*/ PerfManager.Options.PerfMaxStringConstLength,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 4;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("PerfDataMemoryMappedFile");
                    case 1: return get("PerfDataMemorySize");
                    case 2: return get("PerfDataSamplingInterval");
                    case 3: return get("PerfMaxStringConstLength");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
