/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.sbom.packageurl;

import com.oracle.svm.enterprise.sbom.packageurl.c;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;

public final class b {
    private final String BW = b.Z("pkg");
    private final String BX;
    private final String BY;
    private final String BZ;
    private final String Ca;
    private final Map<String, String> Cb;
    private final String Cc;

    public b(String string, String string2, String string3, String string4, TreeMap<String, String> treeMap, String string5) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        this.BX = b.aa(string);
        this.BY = this.ab(string2);
        this.BZ = this.ac(string3);
        this.Ca = b.ad(string4);
        this.Cb = b.h(treeMap);
        this.Cc = b.a(string5, true);
        b.b(this.BX, this.BY, this.BZ);
    }

    private static String Z(String string) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if ("pkg".equals(string)) {
            return "pkg";
        }
        throw new com.oracle.svm.enterprise.sbom.packageurl.a("The PackageURL scheme is invalid");
    }

    private static String aa(String string) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if (string == null || string.isEmpty()) {
            throw new com.oracle.svm.enterprise.sbom.packageurl.a("The PackageURL type cannot be null or empty");
        }
        if (string.charAt(0) >= '0' && string.charAt(0) <= '9') {
            throw new com.oracle.svm.enterprise.sbom.packageurl.a("The PackageURL type cannot start with a number");
        }
        String string2 = string.toLowerCase(Locale.ROOT);
        if (string2.chars().anyMatch(n2 -> !(n2 == 46 || n2 == 43 || n2 == 45 || n2 >= 97 && n2 <= 122 || n2 >= 48 && n2 <= 57))) {
            throw new com.oracle.svm.enterprise.sbom.packageurl.a("The PackageURL type contains invalid characters");
        }
        return string2;
    }

    private String ab(String string) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if (string == null || string.isEmpty()) {
            return null;
        }
        return this.b(string.split("/"));
    }

    private String b(String[] stringArray) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        String string = b.a(stringArray, false);
        return switch (this.BX) {
            case "bitbucket", "deb", "github", "golang", "rpm" -> string.toLowerCase(Locale.ROOT);
            default -> string;
        };
    }

    private String ac(String string) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if (string == null || string.isEmpty()) {
            throw new com.oracle.svm.enterprise.sbom.packageurl.a("The PackageURL name specified is invalid");
        }
        return switch (this.BX) {
            case "bitbucket", "deb", "github", "golang" -> string.toLowerCase(Locale.ROOT);
            case "pypi" -> string.replaceAll("_", "-").toLowerCase(Locale.ROOT);
            default -> string;
        };
    }

    private static String ad(String string) {
        return string;
    }

    private static Map<String, String> h(Map<String, String> map) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if (map == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            b.ae(entry.getKey());
            String string = entry.getValue();
            if (string != null && !string.isEmpty()) continue;
            throw new com.oracle.svm.enterprise.sbom.packageurl.a("The PackageURL specified contains a qualifier key with an empty or null value");
        }
        return map;
    }

    private static void ae(String string) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if (string == null || string.isEmpty()) {
            throw new com.oracle.svm.enterprise.sbom.packageurl.a("Qualifier key is invalid: " + string);
        }
        if (string.charAt(0) >= '0' && string.charAt(0) <= '9' || !string.chars().allMatch(n2 -> n2 >= 97 && n2 <= 122 || n2 >= 48 && n2 <= 57 || n2 == 46 || n2 == 45 || n2 == 95)) {
            throw new com.oracle.svm.enterprise.sbom.packageurl.a("Qualifier key is invalid: " + string);
        }
    }

    private static String a(String string, boolean bl2) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if (string == null || string.isEmpty()) {
            return null;
        }
        return b.a(string.split("/"), bl2);
    }

    private static String a(String[] stringArray, boolean bl2) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        try {
            return Arrays.stream(stringArray).peek(string -> {
                if (bl2 && ("..".equals(string) || ".".equals(string))) {
                    throw new c("Segments in the subpath may not be a period ('.') or repeated period ('..')");
                }
                if (string.contains("/")) {
                    throw new c("Segments in the namespace and subpath may not contain a forward slash ('/')");
                }
                if (string.isEmpty()) {
                    throw new c("Segments in the namespace and subpath may not be empty");
                }
            }).collect(Collectors.joining("/"));
        }
        catch (c c2) {
            throw new com.oracle.svm.enterprise.sbom.packageurl.a(c2.getMessage());
        }
    }

    public String toString() {
        return this.hY();
    }

    public String hY() {
        return this.j(false);
    }

    private String j(boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.BW).append(":");
        if (this.BX != null) {
            stringBuilder.append(this.BX);
        }
        stringBuilder.append("/");
        if (this.BY != null) {
            stringBuilder.append(this.ag(this.BY));
            stringBuilder.append("/");
        }
        if (this.BZ != null) {
            stringBuilder.append(this.af(this.BZ));
        }
        if (this.Ca != null) {
            stringBuilder.append("@").append(this.af(this.Ca));
        }
        if (!bl2) {
            if (this.Cb != null && !this.Cb.isEmpty()) {
                stringBuilder.append("?");
                this.Cb.entrySet().stream().forEachOrdered(entry -> {
                    stringBuilder.append(((String)entry.getKey()).toLowerCase(Locale.ROOT));
                    stringBuilder.append("=");
                    stringBuilder.append(this.af((String)entry.getValue()));
                    stringBuilder.append("&");
                });
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            if (this.Cc != null) {
                stringBuilder.append("#").append(this.ag(this.Cc));
            }
        }
        return stringBuilder.toString();
    }

    private String af(String string) {
        return b.a(string, StandardCharsets.UTF_8);
    }

    private static String a(String string, Charset charset) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : string.getBytes(charset)) {
            if (b.O(by)) {
                stringBuilder.append((char)by);
                continue;
            }
            stringBuilder.append('%');
            stringBuilder.append(Integer.toHexString(by).toUpperCase(Locale.ROOT));
        }
        return stringBuilder.toString();
    }

    private static boolean O(int n2) {
        return b.P(n2) || b.Q(n2) || 45 == n2 || 46 == n2 || 95 == n2 || 126 == n2;
    }

    private static boolean P(int n2) {
        return n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90;
    }

    private static boolean Q(int n2) {
        return n2 >= 48 && n2 <= 57;
    }

    private static void b(String string, String string2, String string3) throws com.oracle.svm.enterprise.sbom.packageurl.a {
        if ("maven".equals(string) && (string2 == null || string2.isEmpty() || string3 == null || string3.isEmpty())) {
            throw new com.oracle.svm.enterprise.sbom.packageurl.a("The PackageURL specified is invalid. Maven requires both a namespace and name.");
        }
    }

    private String ag(String string) {
        return Arrays.stream(string.split("/")).map(this::af).collect(Collectors.joining("/"));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        b b2 = (b)object;
        return Objects.equals(this.BW, b2.BW) && Objects.equals(this.BX, b2.BX) && Objects.equals(this.BY, b2.BY) && Objects.equals(this.BZ, b2.BZ) && Objects.equals(this.Ca, b2.Ca) && Objects.equals(this.Cb, b2.Cb) && Objects.equals(this.Cc, b2.Cc);
    }

    public int hashCode() {
        return Objects.hash(this.BW, this.BX, this.BY, this.BZ, this.Ca, this.Cb, this.Cc);
    }

    public static class a {
        public static final String Cd = "bitbucket";
        public static final String Ce = "deb";
        public static final String Cf = "github";
        public static final String Cg = "golang";
        public static final String Ch = "maven";
        public static final String Ci = "pypi";
        public static final String Cj = "rpm";
    }
}

