/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.loaders;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.profiling.collect.e;
import com.oracle.svm.enterprise.profiling.data.l;
import com.oracle.svm.enterprise.profiling.m;
import com.oracle.svm.enterprise.profiling.metadata.b;
import com.oracle.svm.enterprise.profiling.metadata.codepositions.a;
import com.oracle.svm.enterprise.profiling.metadata.elements.c;
import com.oracle.svm.enterprise.profiling.metadata.elements.d;
import com.oracle.svm.enterprise.profiling.profiles.ProfilingBaseProfile;
import com.oracle.svm.util.LogUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.util.json.JSONParser;
import org.graalvm.util.json.JSONParserException;

public abstract class ProfilingLoader<T, M> {
    public abstract boolean shouldIgnoreProfileVersionCheck();

    public abstract e loadProfile(Path var1);

    public ProfilingBaseProfile loadProfile(List<Path> list, long l2, ProfileData.ProfileSource profileSource) {
        VMError.guarantee((profileSource.isProfiled() || profileSource.isAdopted() || profileSource.isUnknown() ? 1 : 0) != 0);
        return list.stream().map(this::loadProfile).map(e2 -> this.newProfile((e)e2, profileSource)).map(profilingBaseProfile -> profilingBaseProfile.normalize(l2)).reduce(ProfilingBaseProfile::merge).map(profilingBaseProfile -> profilingBaseProfile.normalize(l2)).orElse(null);
    }

    public abstract ProfilingBaseProfile newProfile(e var1, ProfileData.ProfileSource var2);

    public abstract com.oracle.svm.enterprise.profiling.metadata.elements.b<d> getGlobalTypes();

    public abstract com.oracle.svm.enterprise.profiling.metadata.elements.b<c> getGlobalMethods();

    public abstract Map<Integer, T> loadTypes(Map<Integer, d> var1);

    public abstract Map<Integer, M> loadMethods(Map<Integer, d> var1, Map<Integer, c> var2);

    public final void loadNodes(b b2, l l2, List<com.oracle.svm.enterprise.profiling.collect.d> list, byte by, com.oracle.svm.enterprise.profiling.adapters.b<T, M> b3) {
        for (com.oracle.svm.enterprise.profiling.collect.d d2 : list) {
            List<a<?>> list2 = m.a(d2.gE(), this.getCodePositionGenerator(b2, by), b3);
            long[] lArray = d2.gD();
            com.oracle.svm.enterprise.profiling.metadata.cctree.e e2 = b2.o(list2);
            com.oracle.svm.enterprise.profiling.metadata.cctree.d d3 = e2.hf();
            if (e2.hg() && d3 instanceof com.oracle.svm.enterprise.profiling.metadata.cctree.c) {
                com.oracle.svm.enterprise.profiling.metadata.cctree.c c2 = (com.oracle.svm.enterprise.profiling.metadata.cctree.c)d3;
                c2.a(l2, lArray);
                continue;
            }
            int n2 = l2.c(lArray.length, false);
            l2.a(n2, lArray);
            b2.a(list2, by, n2, false);
        }
    }

    protected abstract BiFunction<M, Integer, a<?>> getCodePositionGenerator(b var1, byte var2);

    protected e loadProfile0(Path path, Consumer<String> consumer) {
        try {
            FileInputStream fileInputStream = new FileInputStream(path.toFile());
            InputStream inputStream = ProfilingLoader.handleGzipStream(fileInputStream);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            Object object = new JSONParser((Reader)inputStreamReader).parse();
            e e2 = new e(object);
            com.oracle.svm.enterprise.profiling.collect.b b2 = e2.gF();
            if (b2.gz()) {
                consumer.accept(String.format("Profiles from %s are outdated. Profiles version doesn't exist.", path));
            }
            this.checkIsCompatibleProfileVersion(b2, path, consumer);
            return e2;
        }
        catch (IOException iOException) {
            consumer.accept("Cannot load profile: " + String.valueOf(path) + ". Verify that the file exists and has appropriate access rights.");
        }
        catch (JSONParserException jSONParserException) {
            consumer.accept("Malformed JSON in " + String.valueOf(path));
        }
        return null;
    }

    private void checkIsCompatibleProfileVersion(com.oracle.svm.enterprise.profiling.collect.b b2, Path path, Consumer<String> consumer) {
        if (b2.gy()) {
            String string = String.format("The profile %s, with version %s, is incompatible with the profile version %s, that is supported on GraalVM used for the build. It is possible that given profile is generated with different GraalVM version. Please ensure that you are using a valid and supported profiles.", path, b2.gx(), "0.4.0");
            if (this.shouldIgnoreProfileVersionCheck()) {
                LogUtils.warning((String)string);
            } else {
                consumer.accept(string);
            }
        }
    }

    private static InputStream handleGzipStream(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 2);
        int n2 = pushbackInputStream.read();
        int n3 = pushbackInputStream.read();
        pushbackInputStream.unread(n3);
        pushbackInputStream.unread(n2);
        int n4 = n3 << 8 | n2;
        if (n4 == 35615) {
            return new GZIPInputStream(pushbackInputStream);
        }
        return pushbackInputStream;
    }
}

