/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

public class OrtException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final OrtErrorCode errorCode;

    public OrtException(String string) {
        super(string);
        this.errorCode = OrtErrorCode.ORT_JAVA_UNKNOWN;
    }

    public OrtException(int n2, String string) {
        this(OrtErrorCode.mapFromInt(n2), string);
    }

    public OrtException(OrtErrorCode ortErrorCode, String string) {
        super("Error code - " + (Object)((Object)ortErrorCode) + " - message: " + string);
        this.errorCode = ortErrorCode;
    }

    public OrtErrorCode getCode() {
        return this.errorCode;
    }

    public static enum OrtErrorCode {
        ORT_JAVA_UNKNOWN(-1),
        ORT_OK(0),
        ORT_FAIL(1),
        ORT_INVALID_ARGUMENT(2),
        ORT_NO_SUCHFILE(3),
        ORT_NO_MODEL(4),
        ORT_ENGINE_ERROR(5),
        ORT_RUNTIME_EXCEPTION(6),
        ORT_INVALID_PROTOBUF(7),
        ORT_MODEL_LOADED(8),
        ORT_NOT_IMPLEMENTED(9),
        ORT_INVALID_GRAPH(10),
        ORT_EP_FAIL(11);

        private final int value;
        private static final OrtErrorCode[] values;

        private OrtErrorCode(int n3) {
            this.value = n3;
        }

        public static OrtErrorCode mapFromInt(int n2) {
            if (n2 >= 0 && n2 < values.length) {
                return values[n2];
            }
            return ORT_JAVA_UNKNOWN;
        }

        static {
            values = new OrtErrorCode[12];
            for (OrtErrorCode ortErrorCode : OrtErrorCode.values()) {
                if (ortErrorCode == ORT_JAVA_UNKNOWN) continue;
                OrtErrorCode.values[ortErrorCode.value] = ortErrorCode;
            }
        }
    }
}

