/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

public class Timer {
    private final String name;
    private long startTime;
    private long totalTime;
    private long totalMemory;

    Timer(String name) {
        this.name = name;
    }

    public StopTimer start() {
        this.startTime = System.nanoTime();
        return new StopTimer();
    }

    public void stop() {
        long addTime = System.nanoTime() - this.startTime;
        this.totalTime += addTime;
        this.totalMemory = Runtime.getRuntime().totalMemory();
    }

    public double getTotalTime() {
        return (double)this.totalTime / 1000000.0;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public String getName() {
        return this.name;
    }

    public class StopTimer
    implements AutoCloseable {
        @Override
        public void close() {
            Timer.this.stop();
        }
    }
}

