/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.heap.ImageHeapArray;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class ImageHeapObjectArray
extends ImageHeapArray {
    private static final VarHandle arrayHandle = MethodHandles.arrayElementVarHandle(Object[].class);
    private final Object[] arrayElementValues;

    ImageHeapObjectArray(ResolvedJavaType type, int length) {
        this(type, null, new Object[length]);
    }

    ImageHeapObjectArray(ResolvedJavaType type, JavaConstant object, int length) {
        this(type, object, new Object[length]);
    }

    ImageHeapObjectArray(ResolvedJavaType type, JavaConstant object, Object[] arrayElementValues) {
        this(type, object, arrayElementValues, ImageHeapObjectArray.createIdentityHashCode(object), false);
    }

    private ImageHeapObjectArray(ResolvedJavaType type, JavaConstant object, Object[] arrayElementValues, int identityHashCode, boolean compressed) {
        super(type, object, identityHashCode, compressed);
        assert (type.isArray());
        this.arrayElementValues = arrayElementValues;
    }

    @Override
    public Object getElement(int idx) {
        return arrayHandle.getVolatile(this.arrayElementValues, idx);
    }

    @Override
    public JavaConstant readElementValue(int index) {
        Object value = this.getElement(index);
        return value instanceof JavaConstant ? (JavaConstant)value : (JavaConstant)((AnalysisFuture)value).ensureDone();
    }

    @Override
    public void setElement(int idx, JavaConstant value) {
        arrayHandle.setVolatile(this.arrayElementValues, idx, value);
    }

    public void setElementTask(int idx, AnalysisFuture<JavaConstant> task) {
        arrayHandle.setVolatile(this.arrayElementValues, idx, task);
    }

    @Override
    public int getLength() {
        return this.arrayElementValues.length;
    }

    public JavaConstant compress() {
        assert (!this.compressed);
        return new ImageHeapObjectArray(this.type, this.hostedObject, this.arrayElementValues, this.identityHashCode, true);
    }

    public JavaConstant uncompress() {
        assert (this.compressed);
        return new ImageHeapObjectArray(this.type, this.hostedObject, this.arrayElementValues, this.identityHashCode, false);
    }

    @Override
    public ImageHeapConstant forObjectClone() {
        assert (this.type.isCloneableWithAllocation()) : "all arrays implement Cloneable";
        Object[] newArrayElementValues = Arrays.copyOf(this.arrayElementValues, this.arrayElementValues.length);
        JavaConstant newObject = null;
        return new ImageHeapObjectArray(this.type, newObject, newArrayElementValues, ImageHeapObjectArray.createIdentityHashCode(newObject), this.compressed);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ImageHeapObjectArray) {
            return super.equals(o) && this.arrayElementValues == ((ImageHeapObjectArray)o).arrayElementValues;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + System.identityHashCode(this.arrayElementValues);
        return result;
    }
}

