/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapObjectArray;
import com.oracle.graal.pointsto.heap.ImageHeapPrimitiveArray;
import com.oracle.graal.pointsto.meta.AnalysisType;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaType;

public abstract class ImageHeapArray
extends ImageHeapConstant {
    public static ImageHeapArray create(AnalysisType type, int length) {
        assert (type.isArray());
        return type.getComponentType().getStorageKind().isPrimitive() ? new ImageHeapPrimitiveArray(type, length) : new ImageHeapObjectArray(type, length);
    }

    protected ImageHeapArray(ResolvedJavaType type, JavaConstant object, int identityHashCode, boolean compressed) {
        super(type, object, identityHashCode, compressed);
        assert (type.isArray());
    }

    public abstract Object getElement(int var1);

    public abstract JavaConstant readElementValue(int var1);

    public abstract void setElement(int var1, JavaConstant var2);

    public abstract int getLength();
}

