/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.bytecode;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.MultiTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;

public class ContextSensitiveMultiTypeState
extends MultiTypeState {
    protected final AnalysisObject[] objects;
    protected int[] objectTypeIds;

    public ContextSensitiveMultiTypeState(PointsToAnalysis bb, boolean canBeNull, BitSet typesBitSet, int typesCount, AnalysisObject ... objects) {
        super(bb, canBeNull, typesBitSet, typesCount);
        this.objects = objects;
        assert (objects.length > 1) : "Multi type state with single object.";
        assert (!bb.extendedAsserts() || this.checkObjects(bb));
    }

    protected ContextSensitiveMultiTypeState(PointsToAnalysis bb, boolean canBeNull, ContextSensitiveMultiTypeState other) {
        super(bb, canBeNull, other);
        this.objects = other.objects;
        this.merged = other.merged;
    }

    protected BitSet bitSet() {
        return this.typesBitSet;
    }

    public int[] getObjectTypeIds() {
        if (this.objectTypeIds == null) {
            int[] result = new int[this.objects.length + 1];
            for (int i = 0; i < this.objects.length; ++i) {
                result[i] = this.objects[i].getTypeId();
            }
            this.objectTypeIds = result;
        }
        return this.objectTypeIds;
    }

    private boolean checkObjects(PointsToAnalysis bb) {
        assert (bb.extendedAsserts());
        for (int idx = 0; idx < this.objects.length - 1; ++idx) {
            AnalysisObject o0 = this.objects[idx];
            AnalysisObject o1 = this.objects[idx + 1];
            assert (o0 != null && o1 != null) : "Object state must contain non null elements.";
            assert (o0.type().equals(o1.type()) && o0.getId() < o1.getId() || o0.type().getId() < o1.type().getId()) : "Analysis objects must be sorted by type ID and ID.";
            assert (this.typesBitSet.get(o0.type().getId()));
            assert (this.typesBitSet.get(o1.type().getId()));
        }
        return true;
    }

    @Override
    public int objectsCount() {
        return this.objects.length;
    }

    @Override
    protected Iterator<AnalysisObject> objectsIterator(BigBang bb) {
        return Arrays.asList(this.objects).iterator();
    }

    public int firstTypeId() {
        return this.objects[0].getTypeId();
    }

    public int lastTypeId() {
        return this.objects[this.objects.length - 1].getTypeId();
    }

    @Override
    public TypeState forCanBeNull(PointsToAnalysis bb, boolean resultCanBeNull) {
        if (resultCanBeNull == this.canBeNull()) {
            return this;
        }
        return new ContextSensitiveMultiTypeState(bb, resultCanBeNull, this);
    }

    public Range findTypeRange(AnalysisType type) {
        int lastIdx;
        int firstIdx;
        if (!this.containsType(type)) {
            return Range.EMPTY;
        }
        int someIdx = Arrays.binarySearch(this.objects, type.getContextInsensitiveAnalysisObject(), AnalysisObject.objectsTypeComparator);
        assert (someIdx >= 0) : "The inquired type must be in the array.";
        for (firstIdx = someIdx; firstIdx >= 0 && this.objects[firstIdx].getTypeId() == type.getId(); --firstIdx) {
        }
        for (lastIdx = someIdx; lastIdx < this.objects.length && this.objects[lastIdx].getTypeId() == type.getId(); ++lastIdx) {
        }
        return Range.range(firstIdx + 1, lastIdx);
    }

    public AnalysisObject[] objectsArray(AnalysisType type) {
        Range typeRange = this.findTypeRange(type);
        return Arrays.copyOfRange(this.objects, typeRange.left, typeRange.right);
    }

    public AnalysisObject[] objectsArray(Range typeRange) {
        return Arrays.copyOfRange(this.objects, typeRange.left, typeRange.right);
    }

    @Override
    public Iterator<AnalysisObject> objectsIterator(final AnalysisType exactType) {
        return new Iterator<AnalysisObject>(){
            private final Range typeRange;
            private int idx;
            {
                this.typeRange = ContextSensitiveMultiTypeState.this.findTypeRange(exactType);
                this.idx = this.typeRange.left;
            }

            @Override
            public boolean hasNext() {
                return this.idx < this.typeRange.right;
            }

            @Override
            public AnalysisObject next() {
                return ContextSensitiveMultiTypeState.this.objects[this.idx++];
            }
        };
    }

    @Override
    public void noteMerge(PointsToAnalysis bb) {
        assert (bb.analysisPolicy().isMergingEnabled());
        if (!this.merged) {
            for (AnalysisObject obj : this.objects) {
                obj.noteMerge(bb);
            }
            this.merged = true;
        }
    }

    @Override
    public boolean isMerged() {
        return this.merged;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.objects);
        result = 31 * result + (this.canBeNull ? 1 : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextSensitiveMultiTypeState that = (ContextSensitiveMultiTypeState)o;
        return this.canBeNull == that.canBeNull && this.typesCount == that.typesCount && this.typesBitSet.equals(that.typesBitSet) && Arrays.equals(this.objects, that.objects);
    }

    @Override
    public String toString() {
        return "MTypeMObject<" + this.objects.length + ":" + (this.canBeNull ? "null," : "") + Arrays.toString(this.objects) + ">";
    }

    public static class Range {
        static final Range EMPTY = new Range(0, 0);
        final int left;
        protected final int right;

        protected static Range range(int up, int low) {
            return new Range(up, low);
        }

        Range(int left, int right) {
            this.left = left;
            this.right = right;
        }

        public int left() {
            return this.left;
        }

        public int right() {
            return this.right;
        }

        public String toString() {
            return "[" + this.left + ", " + this.right + ")";
        }
    }
}

