/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.code.BytecodePosition;

public abstract class AnalysisContextPolicy<C extends AnalysisContext> {
    private final ContextFactory factory = new ContextFactory();
    private final C emptyContext;

    public AnalysisContextPolicy(C emptyContext) {
        this.emptyContext = this.factory.lookupContext(emptyContext);
    }

    public final C emptyContext() {
        return this.emptyContext;
    }

    public final boolean isEmpty(C context) {
        return context == this.emptyContext;
    }

    public abstract C calleeContext(PointsToAnalysis var1, AnalysisObject var2, C var3, MethodTypeFlow var4);

    public abstract C staticCalleeContext(PointsToAnalysis var1, BytecodePosition var2, C var3, MethodTypeFlow var4);

    public abstract C allocationContext(C var1, int var2);

    public abstract C peel(C var1, int var2);

    public static BytecodePosition[] extend(BytecodePosition[] labelList, BytecodePosition add, int maxDepth) {
        int resultingContextDepth = labelList.length == maxDepth ? maxDepth : labelList.length + 1;
        BytecodePosition[] resultingLabelList = new BytecodePosition[resultingContextDepth];
        int i = resultingContextDepth - 2;
        for (int j = labelList.length - 1; i >= 0 && j >= 0; --i, --j) {
            resultingLabelList[i] = labelList[j];
        }
        if (resultingContextDepth > 0) {
            resultingLabelList[resultingContextDepth - 1] = add;
        }
        return resultingLabelList;
    }

    public static BytecodePosition[] extend(BytecodePosition[] labelList, BytecodePosition add) {
        BytecodePosition[] result = Arrays.copyOf(labelList, labelList.length + 1);
        result[result.length - 1] = add;
        return result;
    }

    public static BytecodePosition[] peel(BytecodePosition[] labelList, int maxDepth) {
        assert (maxDepth >= 0);
        assert (labelList.length > maxDepth);
        BytecodePosition[] resultingLabelList = new BytecodePosition[maxDepth];
        int i = maxDepth - 1;
        for (int j = labelList.length - 1; i >= 0 && j >= 0; --i, --j) {
            resultingLabelList[i] = labelList[j];
        }
        return resultingLabelList;
    }

    public AnalysisContext lookupContext(C context) {
        return this.factory.lookupContext(context);
    }

    private class ContextFactory {
        private final ConcurrentHashMap<AnalysisContext.AnalysisContextKey, C> allContexts = new ConcurrentHashMap();

        protected ContextFactory() {
        }

        protected C lookupContext(C newContext) {
            AnalysisContext.AnalysisContextKey key = ((AnalysisContext)newContext).asKey();
            AnalysisContext oldContext = (AnalysisContext)this.allContexts.get(key);
            if (oldContext == null) {
                oldContext = (AnalysisContext)this.allContexts.putIfAbsent(key, newContext);
                oldContext = oldContext != null ? oldContext : newContext;
            }
            return oldContext;
        }
    }
}

