/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.x509;

import com.oracle.jipher.pki.internal.CrlFileName;
import com.oracle.jipher.pki.internal.Debug;
import com.oracle.jipher.pki.x509.CrlStoreException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.x500.X500Principal;

public class CrlFileStore {
    private static final Debug DEBUG = Debug.getInstance("CrlFileStore");
    private Path storePath;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private CertificateFactory cf;
    private boolean jgFormatFilesOnly;

    public static CrlFileStore create(Path dirPath) throws CrlStoreException {
        try {
            Files.createDirectory(dirPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new CrlStoreException("Could not create store path", e);
        }
        return new CrlFileStore(dirPath, Mode.STANDARD);
    }

    public static CrlFileStore open(Path dirPath, Mode mode) throws CrlStoreException {
        return new CrlFileStore(dirPath, mode);
    }

    private CrlFileStore(Path dirPath, Mode mode) throws CrlStoreException {
        if (dirPath == null || !dirPath.toFile().exists() || !dirPath.toFile().isDirectory()) {
            throw new CrlStoreException("CRL Store Path must exist and be a directory");
        }
        this.storePath = dirPath;
        this.jgFormatFilesOnly = mode == null || mode == Mode.STANDARD;
        try {
            this.cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new CrlStoreException(e);
        }
    }

    public Collection<X500Principal> getIssuers() throws CrlStoreException {
        HashSet issuers = new HashSet();
        this.findAndCollect(f -> !this.jgFormatFilesOnly || CrlFileName.isSupportedName(f), (f, c) -> !this.jgFormatFilesOnly || CrlFileName.isForCrl(f, c), (f, crl) -> issuers.add(crl.getIssuerX500Principal()));
        return Collections.unmodifiableSet(issuers);
    }

    public Collection<X509CRL> load(X500Principal issuer) throws CrlStoreException {
        HashSet set = new HashSet();
        this.findAndCollect(f -> !this.jgFormatFilesOnly || CrlFileName.isForIssuer(f, issuer), (f, crl) -> issuer.equals(crl.getIssuerX500Principal()), (f, crl) -> set.add(crl));
        return Collections.unmodifiableSet(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(X509CRL toAdd) throws CRLException, IOException, CrlStoreException {
        LinkedHashMap crls = new LinkedHashMap();
        this.findAndCollect(f -> !this.jgFormatFilesOnly || CrlFileName.isForCrl(f, toAdd), (f, crl) -> crl.equals(toAdd), crls::put);
        if (!crls.isEmpty()) {
            DEBUG.println(() -> "CRL already exists, nothing to be done.");
            return;
        }
        this.lock.writeLock().lock();
        try {
            int suffix = 0;
            Path tstFile = Paths.get(this.storePath.toString(), CrlFileName.create(toAdd, suffix));
            while (Files.exists(tstFile, new LinkOption[0])) {
                try {
                    FileInputStream fis222;
                    block13: {
                        fis222 = new FileInputStream(tstFile.toFile());
                        try {
                            X509CRL crl2 = (X509CRL)this.cf.generateCRL(fis222);
                            if (!crl2.equals(toAdd)) break block13;
                            DEBUG.println(() -> "CRL already exists, nothing to be done.");
                        }
                        catch (Throwable throwable) {
                            try {
                                fis222.close();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        fis222.close();
                        return;
                    }
                    fis222.close();
                }
                catch (CRLException fis222) {
                    // empty catch block
                }
                tstFile = Paths.get(this.storePath.toString(), CrlFileName.create(toAdd, ++suffix));
            }
            Path newCrlFile = tstFile.toAbsolutePath();
            Files.write(newCrlFile, toAdd.getEncoded(), StandardOpenOption.CREATE_NEW);
            DEBUG.println(() -> "Created CRL file: " + newCrlFile.toString());
            return;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean delete(X509CRL toDelete) throws CrlStoreException {
        return this.delete((File f) -> !this.jgFormatFilesOnly || CrlFileName.isForCrl(f, toDelete), (File f, X509CRL crl) -> crl.equals(toDelete));
    }

    public boolean delete(X500Principal issuerToDelete, Date thisUpdate) throws CrlStoreException {
        return this.delete((File f) -> !this.jgFormatFilesOnly || CrlFileName.isForIssuer(f, issuerToDelete), (File f, X509CRL crl) -> crl.getIssuerX500Principal().equals(issuerToDelete) && crl.getThisUpdate().equals(thisUpdate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean delete(FileFilter fileFilter, CrlFilter filter) throws CrlStoreException {
        Map<File, X509CRL> crls = this.find(fileFilter, filter);
        if (crls.isEmpty()) {
            DEBUG.println("No matching CRLs found to delete");
            return false;
        }
        this.lock.writeLock().lock();
        boolean deleted = false;
        try {
            for (File f : crls.keySet()) {
                try {
                    if (f.exists()) {
                        Files.delete(f.toPath());
                    }
                    DEBUG.println(() -> "Deleted CRL file: " + f.toString());
                    deleted = true;
                }
                catch (IOException e) {
                    DEBUG.println(() -> "Failed to delete CRL file: " + f.toString());
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return deleted;
    }

    private Map<File, X509CRL> find(FileFilter fileFilter, CrlFilter filter) throws CrlStoreException {
        LinkedHashMap<File, X509CRL> fileMap = new LinkedHashMap<File, X509CRL>();
        this.findAndCollect(fileFilter, filter, fileMap::put);
        return fileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAndCollect(FileFilter fileFilter, CrlFilter filter, Collector coll) throws CrlStoreException {
        this.lock.readLock().lock();
        try {
            File[] files = this.storePath.toFile().listFiles();
            if (files == null) {
                throw new CrlStoreException("CRL Store path not valid: " + this.storePath);
            }
            for (File f : files) {
                if (!f.isFile() || !fileFilter.matches(f)) continue;
                try (FileInputStream fis = new FileInputStream(f);){
                    X509CRL crl = (X509CRL)this.cf.generateCRL(fis);
                    if (!filter.matches(f, crl)) continue;
                    coll.collect(f, crl);
                }
                catch (IOException | CRLException e) {
                    throw new CrlStoreException("Could not load CRL from file: " + f, e);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static enum Mode {
        STANDARD,
        COMPATIBILITY;

    }

    static interface FileFilter {
        public boolean matches(File var1);
    }

    static interface CrlFilter {
        public boolean matches(File var1, X509CRL var2);
    }

    static interface Collector {
        public void collect(File var1, X509CRL var2);
    }
}

