/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import jdk.internal.module.Modules;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class ModuleSupport {
    public static final String MODULE_SET_ALL_DEFAULT = "ALL-DEFAULT";
    public static final String MODULE_SET_ALL_SYSTEM = "ALL-SYSTEM";
    public static final String MODULE_SET_ALL_MODULE_PATH = "ALL-MODULE-PATH";
    public static final List<String> nonExplicitModules = List.of("ALL-DEFAULT", "ALL-SYSTEM", "ALL-MODULE-PATH");
    public static final String ENV_VAR_USE_MODULE_SYSTEM = "USE_NATIVE_IMAGE_JAVA_PLATFORM_MODULE_SYSTEM";
    public static final String PROPERTY_IMAGE_EXPLICITLY_ADDED_MODULES = "org.graalvm.nativeimage.module.addmods";
    public static final String PROPERTY_IMAGE_EXPLICITLY_LIMITED_MODULES = "org.graalvm.nativeimage.module.limitmods";
    public static final boolean modulePathBuild = ModuleSupport.isModulePathBuild();

    private ModuleSupport() {
    }

    private static boolean isModulePathBuild() {
        return !"false".equalsIgnoreCase(System.getenv().get(ENV_VAR_USE_MODULE_SYSTEM));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void accessModuleByClass(Access access, Class<?> accessingClass, Class<?> declaringClass) {
        ModuleSupport.accessModuleByClass(access, accessingClass, declaringClass.getModule(), declaringClass.getPackageName());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void accessPackagesToClass(Access access, Class<?> accessingClass, boolean optional, String moduleName, String ... packageNames) {
        Objects.requireNonNull(moduleName);
        Optional<Module> module = ModuleLayer.boot().findModule(moduleName);
        if (module.isEmpty()) {
            if (optional) {
                return;
            }
            String accessor = accessingClass != null ? "class " + accessingClass.getTypeName() : "ALL-UNNAMED";
            String message = access.name().toLowerCase() + " of packages from module " + moduleName + " to " + accessor + " failed. No module named " + moduleName + " in boot layer.";
            throw new ModuleSupportError(message);
        }
        Module declaringModule = module.get();
        Objects.requireNonNull(packageNames);
        Set<String> packages = packageNames.length > 0 ? Set.of(packageNames) : declaringModule.getPackages();
        for (String packageName : packages) {
            ModuleSupport.accessModuleByClass(access, accessingClass, declaringModule, packageName);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void accessModuleByClass(Access access, Class<?> accessingClass, Module declaringModule, String packageName) {
        Module accessingModule;
        Module namedAccessingModule = null;
        if (accessingClass != null && (accessingModule = accessingClass.getModule()).isNamed()) {
            namedAccessingModule = accessingModule;
        }
        access.giveAccess(namedAccessingModule, declaringModule, packageName);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void accessModule(Access access, Module accessingModule, Module declaringModule, String packageName) {
        access.giveAccess(accessingModule, declaringModule, packageName);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static enum Access {
        OPEN{

            @Override
            void giveAccess(Module accessingModule, Module declaringModule, String packageName) {
                if (accessingModule != null) {
                    if (declaringModule.isOpen(packageName, accessingModule)) {
                        return;
                    }
                    Modules.addOpens(declaringModule, packageName, accessingModule);
                } else {
                    if (declaringModule.isOpen(packageName)) {
                        return;
                    }
                    Modules.addOpensToAllUnnamed(declaringModule, packageName);
                }
            }
        }
        ,
        EXPORT{

            @Override
            void giveAccess(Module accessingModule, Module declaringModule, String packageName) {
                if (accessingModule != null) {
                    if (declaringModule.isExported(packageName, accessingModule)) {
                        return;
                    }
                    Modules.addExports(declaringModule, packageName, accessingModule);
                } else {
                    if (declaringModule.isExported(packageName)) {
                        return;
                    }
                    Modules.addExportsToAllUnnamed(declaringModule, packageName);
                }
            }
        };


        abstract void giveAccess(Module var1, Module var2, String var3);
    }

    public static final class ModuleSupportError
    extends Error {
        private ModuleSupportError(String message) {
            super(message);
        }
    }
}

