/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class ObservableMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentHashMap<K, V> wrapped = new ConcurrentHashMap();
    private final List<MappingObserver> observers = new CopyOnWriteArrayList<MappingObserver>();

    public void addObserver(MappingObserver observer) {
        this.observers.add(observer);
        this.forEach(observer::notify);
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrapped.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrapped.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.wrapped.get(key);
    }

    @Override
    public V put(K key, V value) {
        V previous = this.wrapped.put(key, value);
        if (previous != value) {
            this.observers.forEach((? super T o) -> o.notify(key, value));
        }
        return previous;
    }

    @Override
    public V remove(Object key) {
        return this.wrapped.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.wrapped.putAll(m);
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.observers.forEach((? super T o) -> o.notify(entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.wrapped.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.wrapped.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.wrapped.entrySet();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V previous = this.wrapped.putIfAbsent(key, value);
        if (previous == null) {
            this.observers.forEach((? super T o) -> o.notify(key, value));
        }
        return previous;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.wrapped.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        boolean replaced = this.wrapped.replace(key, oldValue, newValue);
        if (replaced) {
            this.observers.forEach((? super T o) -> o.notify(key, newValue));
        }
        return replaced;
    }

    @Override
    public V replace(K key, V value) {
        V previous = this.wrapped.replace(key, value);
        if (previous != null) {
            this.observers.forEach((? super T o) -> o.notify(key, value));
        }
        return previous;
    }

    public static interface MappingObserver {
        public void notify(Object var1, Object var2);
    }
}

