/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.svm.hosted.ameta.ReadableJavaField;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import com.oracle.svm.hosted.annotation.AnnotationWrapper;
import com.oracle.svm.hosted.annotation.SubstrateAnnotationExtractor;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public class AnnotatedField
implements ReadableJavaField,
OriginalFieldProvider,
AnnotationWrapper {
    private final ResolvedJavaField original;
    private final AnnotationValue[] injectedAnnotations;

    public AnnotatedField(ResolvedJavaField original, Annotation injectedAnnotation) {
        this.original = original;
        this.injectedAnnotations = SubstrateAnnotationExtractor.prepareInjectedAnnotations(injectedAnnotation);
    }

    @Override
    public AnnotatedElement getAnnotationRoot() {
        return this.original;
    }

    @Override
    public AnnotationValue[] getInjectedAnnotations() {
        return this.injectedAnnotations;
    }

    @Override
    public JavaConstant readValue(MetaAccessProvider metaAccess, ClassInitializationSupport classInitializationSupport, JavaConstant receiver) {
        return ReadableJavaField.readFieldValue(metaAccess, classInitializationSupport, this.original, receiver);
    }

    @Override
    public boolean isValueAvailableBeforeAnalysis() {
        return false;
    }

    @Override
    public boolean injectFinalForRuntimeCompilation() {
        return ReadableJavaField.injectFinalForRuntimeCompilation(this.original);
    }

    public String getName() {
        return this.original.getName();
    }

    public JavaType getType() {
        return this.original.getType();
    }

    public int getModifiers() {
        return this.original.getModifiers();
    }

    public int getOffset() {
        return this.original.getOffset();
    }

    public boolean isInternal() {
        return this.original.isInternal();
    }

    public boolean isSynthetic() {
        return this.original.isSynthetic();
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.original.getDeclaringClass();
    }

    public String toString() {
        return "InjectedAnnotationField<original " + this.original.toString() + ", annotation: " + String.valueOf(this.injectedAnnotations[0]) + ">";
    }

    public Field getJavaField() {
        return OriginalFieldProvider.getJavaField((ResolvedJavaField)this.original);
    }

    public JavaConstant getConstantValue() {
        return this.original.getConstantValue();
    }
}

