/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.infrastructure.WrappedConstantPool;
import com.oracle.graal.pointsto.infrastructure.WrappedSignature;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.results.AbstractAnalysisResultsBuilder;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.FunctionPointerHolder;
import com.oracle.svm.core.InvalidMethodPointerHandler;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.BoxedRelocatedPointer;
import com.oracle.svm.core.c.function.CFunctionOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.heap.ExcludeFromReferenceMap;
import com.oracle.svm.core.heap.FillerArray;
import com.oracle.svm.core.heap.FillerObject;
import com.oracle.svm.core.heap.InstanceReferenceMapEncoder;
import com.oracle.svm.core.heap.ReferenceMapEncoder;
import com.oracle.svm.core.heap.SmallestPossibleObject;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.SubstrateReferenceMap;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.reflect.SubstrateConstructorAccessor;
import com.oracle.svm.core.reflect.SubstrateMethodAccessor;
import com.oracle.svm.core.reflect.serialize.SerializationRegistry;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.HostedConfiguration;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.heap.PodSupport;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedInterface;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedPrimitiveType;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.MaterializedConstantFields;
import com.oracle.svm.hosted.meta.TypeCheckBuilder;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.hosted.substitute.ComputedValueField;
import com.oracle.svm.hosted.substitute.DeletedMethod;
import com.oracle.svm.util.ReflectionUtil;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinTask;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.internal.vm.annotation.Contended;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

public class UniverseBuilder {
    private final AnalysisUniverse aUniverse;
    private final AnalysisMetaAccess aMetaAccess;
    private final HostedUniverse hUniverse;
    private final HostedMetaAccess hMetaAccess;
    private AbstractAnalysisResultsBuilder staticAnalysisResultsBuilder;
    private final UnsupportedFeatures unsupportedFeatures;
    private TypeCheckBuilder typeCheckBuilder;
    private static final Set<Class<?>> IMMUTABLE_TYPES = new HashSet<Class>(Arrays.asList(String.class, DynamicHub.class, CEntryPointLiteral.class, BoxedRelocatedPointer.class, FunctionPointerHolder.class, StoredContinuation.class, SubstrateMethodAccessor.class, SubstrateConstructorAccessor.class, SmallestPossibleObject.class, FillerObject.class, FillerArray.class));
    private static final Comparator<HostedField> FIELD_LOCATION_COMPARATOR = (a, b) -> {
        if (!a.hasLocation() || !b.hasLocation()) {
            return Boolean.compare(a.hasLocation(), b.hasLocation());
        }
        return Integer.compare(a.getLocation(), b.getLocation());
    };

    public UniverseBuilder(AnalysisUniverse aUniverse, AnalysisMetaAccess aMetaAccess, HostedUniverse hUniverse, HostedMetaAccess hMetaAccess, AbstractAnalysisResultsBuilder staticAnalysisResultsBuilder, UnsupportedFeatures unsupportedFeatures) {
        this.aUniverse = aUniverse;
        this.aMetaAccess = aMetaAccess;
        this.hUniverse = hUniverse;
        this.hMetaAccess = hMetaAccess;
        this.staticAnalysisResultsBuilder = staticAnalysisResultsBuilder;
        this.unsupportedFeatures = unsupportedFeatures;
    }

    public void build(DebugContext debug) {
        for (Object aField : this.aUniverse.getFields()) {
            if (!(((AnalysisField)aField).wrapped instanceof ComputedValueField)) continue;
            ((ComputedValueField)((AnalysisField)aField).wrapped).processAnalysis(this.aMetaAccess);
        }
        this.aUniverse.seal();
        try (Indent indent = debug.logAndIndent("build universe");){
            for (AnalysisType aType : this.aUniverse.getTypes()) {
                this.makeType(aType);
            }
            for (AnalysisField aField : this.aUniverse.getFields()) {
                this.makeField(aField);
            }
            for (AnalysisMethod aMethod : this.aUniverse.getMethods()) {
                assert (aMethod.isOriginalMethod());
                Collection allMethods = aMethod.getAllMultiMethods();
                HostedMethod origHMethod = null;
                if (allMethods.size() == 1) {
                    origHMethod = this.makeMethod(aMethod);
                } else {
                    ConcurrentHashMap<MultiMethod.MultiMethodKey, MultiMethod> multiMethodMap = new ConcurrentHashMap<MultiMethod.MultiMethodKey, MultiMethod>();
                    for (MultiMethod method : aMethod.getAllMultiMethods()) {
                        HostedMethod hMethod = this.makeMethod((AnalysisMethod)method);
                        hMethod.setMultiMethodMap(multiMethodMap);
                        MultiMethod previous = multiMethodMap.put(hMethod.getMultiMethodKey(), hMethod);
                        assert (previous == null) : "Overwriting multimethod key";
                        if (!method.equals((Object)aMethod)) continue;
                        origHMethod = hMethod;
                    }
                }
                assert (origHMethod != null);
                HostedMethod previous = this.hUniverse.methods.put(aMethod, origHMethod);
                assert (previous == null) : "Overwriting analysis key";
            }
            Collection<HostedType> allTypes = this.hUniverse.types.values();
            HostedType objectType = this.hUniverse.objectType();
            HostedType cloneableType = this.hUniverse.types.get(this.aMetaAccess.lookupJavaType(Cloneable.class));
            HostedType serializableType = this.hUniverse.types.get(this.aMetaAccess.lookupJavaType(Serializable.class));
            this.typeCheckBuilder = new TypeCheckBuilder(allTypes, objectType, cloneableType, serializableType);
            this.typeCheckBuilder.buildTypeInformation(this.hUniverse);
            this.typeCheckBuilder.calculateIDs();
            this.collectDeclaredMethods();
            this.collectMonitorFieldInfo(this.staticAnalysisResultsBuilder.getBigBang());
            ForkJoinTask<?> profilingInformationBuildTask = ForkJoinTask.adapt(this::buildProfilingInformation).fork();
            this.layoutInstanceFields();
            this.layoutStaticFields();
            this.collectMethodImplementations();
            this.buildVTables();
            this.buildHubs();
            this.processFieldLocations();
            this.hUniverse.orderedMethods = new ArrayList<HostedMethod>(this.hUniverse.methods.values());
            Collections.sort(this.hUniverse.orderedMethods, HostedUniverse.METHOD_COMPARATOR);
            this.hUniverse.orderedFields = new ArrayList<HostedField>(this.hUniverse.fields.values());
            Collections.sort(this.hUniverse.orderedFields, HostedUniverse.FIELD_COMPARATOR_RELAXED);
            profilingInformationBuildTask.join();
        }
    }

    private HostedType lookupType(AnalysisType aType) {
        return Objects.requireNonNull(this.hUniverse.types.get(aType));
    }

    private HostedType makeType(AnalysisType aType) {
        if (aType == null) {
            return null;
        }
        HostedType hType = this.hUniverse.types.get(aType);
        if (hType != null) {
            return hType;
        }
        String typeName = aType.getName();
        assert (SubstrateUtil.isBuildingLibgraal() || !typeName.contains("/hotspot/") || typeName.contains("/jtt/hotspot/") || typeName.contains("/hotspot/shared/")) : "HotSpot object in image " + typeName;
        assert (!typeName.contains("/analysis/meta/")) : "Analysis meta object in image " + typeName;
        assert (!typeName.contains("/hosted/meta/")) : "Hosted meta object in image " + typeName;
        AnalysisType[] aInterfaces = aType.getInterfaces();
        HostedInterface[] sInterfaces = new HostedInterface[aInterfaces.length];
        for (int i = 0; i < aInterfaces.length; ++i) {
            sInterfaces[i] = (HostedInterface)this.makeType(aInterfaces[i]);
        }
        JavaKind kind = aType.getJavaKind();
        JavaKind storageKind = aType.getStorageKind();
        if (aType.getJavaKind() != JavaKind.Object) {
            assert (!(aType.isInterface() || aType.isInstanceClass() || aType.isArray()));
            hType = new HostedPrimitiveType(this.hUniverse, aType, kind, storageKind);
            this.hUniverse.kindToType.put(hType.getJavaKind(), hType);
        } else if (aType.isInterface()) {
            assert (!aType.isInstanceClass() && !aType.isArray());
            hType = new HostedInterface(this.hUniverse, aType, kind, storageKind, sInterfaces);
        } else if (aType.isInstanceClass()) {
            assert (!aType.isInterface() && !aType.isArray());
            HostedInstanceClass superClass = (HostedInstanceClass)this.makeType(aType.getSuperclass());
            hType = new HostedInstanceClass(this.hUniverse, aType, kind, storageKind, superClass, sInterfaces);
            if (superClass == null) {
                this.hUniverse.kindToType.put(JavaKind.Object, hType);
            }
        } else if (aType.isArray()) {
            assert (!aType.isInterface() && !aType.isInstanceClass());
            HostedClass superType = (HostedClass)this.makeType(aType.getSuperclass());
            HostedType componentType = this.makeType(aType.getComponentType());
            hType = new HostedArrayClass(this.hUniverse, aType, kind, storageKind, superType, sInterfaces, componentType);
        } else {
            throw VMError.shouldNotReachHereUnexpectedInput(aType);
        }
        HostedType existing = this.hUniverse.types.put(aType, hType);
        if (existing != null) {
            throw VMError.shouldNotReachHere("Overwriting existing type: " + String.valueOf(hType) + " != " + String.valueOf(existing));
        }
        DynamicHub hub = hType.getHub();
        Class<?> hostedJavaClass = hub.getHostedJavaClass();
        AnalysisType aTypeChecked = this.aMetaAccess.lookupJavaType(hostedJavaClass);
        ResolvedJavaType hTypeChecked = this.hMetaAccess.lookupJavaType((Class)hostedJavaClass);
        if (!UniverseBuilder.sameObject(aType, aTypeChecked) || !UniverseBuilder.sameObject(hTypeChecked, hType)) {
            throw VMError.shouldNotReachHere("Type mismatch when performing round-trip HostedType/AnalysisType -> DynamicHub -> java.lang.Class -> HostedType/AnalysisType: " + System.lineSeparator() + String.valueOf(hType) + " @ " + Integer.toHexString(System.identityHashCode(hType)) + " / " + String.valueOf(aType) + " @ " + Integer.toHexString(System.identityHashCode(aType)) + System.lineSeparator() + " -> " + String.valueOf(hub) + " -> " + String.valueOf(hostedJavaClass) + System.lineSeparator() + " -> " + String.valueOf(hTypeChecked) + " @ " + Integer.toHexString(System.identityHashCode(hTypeChecked)) + " / " + String.valueOf(aTypeChecked) + " @ " + Integer.toHexString(System.identityHashCode(aTypeChecked)));
        }
        return hType;
    }

    private static boolean sameObject(Object x, Object y) {
        return x == y;
    }

    private HostedMethod makeMethod(AnalysisMethod aMethod) {
        boolean hasCFunctionOptions;
        AnalysisType aDeclaringClass = aMethod.getDeclaringClass();
        HostedType hDeclaringClass = this.lookupType(aDeclaringClass);
        Signature signature = this.makeSignature((Signature)aMethod.getSignature(), aDeclaringClass);
        ConstantPool constantPool = this.makeConstantPool(aMethod.getConstantPool(), aDeclaringClass);
        ExceptionHandler[] aHandlers = aMethod.getExceptionHandlers();
        ExceptionHandler[] sHandlers = new ExceptionHandler[aHandlers.length];
        for (int i = 0; i < aHandlers.length; ++i) {
            ExceptionHandler h = aHandlers[i];
            Object catchType = h.getCatchType();
            if (h.getCatchType() instanceof AnalysisType) {
                catchType = this.lookupType((AnalysisType)catchType);
            } else assert (catchType == null || catchType instanceof UnresolvedJavaType);
            sHandlers[i] = new ExceptionHandler(h.getStartBCI(), h.getEndBCI(), h.getHandlerBCI(), h.catchTypeCPI(), catchType);
        }
        HostedMethod hMethod = HostedMethod.create(this.hUniverse, aMethod, hDeclaringClass, signature, constantPool, sHandlers);
        boolean isCFunction = aMethod.getAnnotation(CFunction.class) != null;
        boolean bl = hasCFunctionOptions = aMethod.getAnnotation(CFunctionOptions.class) != null;
        if (hasCFunctionOptions && !isCFunction) {
            this.unsupportedFeatures.addMessage(aMethod.format("%H.%n(%p)"), aMethod, "Method annotated with @" + CFunctionOptions.class.getSimpleName() + " must also be annotated with @" + String.valueOf(CFunction.class));
        }
        if (isCFunction) {
            if (!aMethod.isNative()) {
                this.unsupportedFeatures.addMessage(aMethod.format("%H.%n(%p)"), aMethod, "Method annotated with @" + CFunction.class.getSimpleName() + " must be declared native");
            }
        } else if (aMethod.isNative() && !aMethod.isIntrinsicMethod() && !(aMethod.getWrapped() instanceof CustomSubstitutionMethod) && aMethod.isImplementationInvoked() && !NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
            this.unsupportedFeatures.addMessage(aMethod.format("%H.%n(%p)"), aMethod, AnnotationSubstitutionProcessor.deleteErrorMessage((AnnotatedElement)aMethod, DeletedMethod.NATIVE_MESSAGE, true));
        }
        return hMethod;
    }

    private Signature makeSignature(Signature aSignature, AnalysisType aDefaultAccessingClass) {
        WrappedSignature hSignature = this.hUniverse.signatures.get(aSignature);
        if (hSignature == null) {
            hSignature = new WrappedSignature((Universe)this.hUniverse, aSignature, (ResolvedJavaType)aDefaultAccessingClass);
            this.hUniverse.signatures.put(aSignature, hSignature);
            for (int i = 0; i < aSignature.getParameterCount(false); ++i) {
                this.lookupType((AnalysisType)aSignature.getParameterType(i, null));
            }
            this.lookupType((AnalysisType)aSignature.getReturnType(null));
        }
        return hSignature;
    }

    private ConstantPool makeConstantPool(ConstantPool aConstantPool, AnalysisType aDefaultAccessingClass) {
        WrappedConstantPool hConstantPool = this.hUniverse.constantPools.get(aConstantPool);
        if (hConstantPool == null) {
            hConstantPool = new WrappedConstantPool((Universe)this.hUniverse, aConstantPool, (ResolvedJavaType)aDefaultAccessingClass);
            this.hUniverse.constantPools.put(aConstantPool, hConstantPool);
        }
        return hConstantPool;
    }

    private void makeField(AnalysisField aField) {
        HostedType holder = this.lookupType(aField.getDeclaringClass());
        HostedType type = this.lookupType(aField.getType());
        HostedField hField = new HostedField(aField, holder, type, this.staticAnalysisResultsBuilder.makeTypeProfile(aField));
        assert (!this.hUniverse.fields.containsKey(aField));
        this.hUniverse.fields.put(aField, hField);
    }

    private void buildProfilingInformation() {
        this.hUniverse.methods.values().parallelStream().forEach(method -> {
            assert (method.isOriginalMethod());
            for (MultiMethod multiMethod : method.getAllMultiMethods()) {
                HostedMethod hMethod = (HostedMethod)multiMethod;
                hMethod.staticAnalysisResults = this.staticAnalysisResultsBuilder.makeOrApplyResults(hMethod.getWrapped());
            }
        });
        this.staticAnalysisResultsBuilder = null;
    }

    private void collectMonitorFieldInfo(BigBang bb) {
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return;
        }
        HostedConfiguration.instance().collectMonitorFieldInfo(bb, this.hUniverse, this.getImmutableTypes());
    }

    private Set<AnalysisType> getImmutableTypes() {
        HashSet<AnalysisType> immutableTypes = new HashSet<AnalysisType>();
        for (Class<?> immutableType : IMMUTABLE_TYPES) {
            Optional aType = this.aMetaAccess.optionalLookupJavaType(immutableType);
            aType.ifPresent(immutableTypes::add);
        }
        return immutableTypes;
    }

    public static boolean isKnownImmutableType(Class<?> clazz) {
        return IMMUTABLE_TYPES.contains(clazz);
    }

    private void layoutInstanceFields() {
        BitSet usedBytes = new BitSet();
        usedBytes.set(0, ConfigurationValues.getObjectLayout().getFirstFieldOffset());
        this.layoutInstanceFields(this.hUniverse.getObjectClass(), new HostedField[0], usedBytes);
    }

    private static boolean mustReserveLengthField(HostedInstanceClass clazz) {
        if (PodSupport.isPresent() && PodSupport.singleton().mustReserveLengthField(clazz.getJavaClass())) {
            return true;
        }
        if (HybridLayout.isHybrid(clazz)) {
            return !PodSupport.isPresent() || !PodSupport.singleton().isPodClass(clazz.getJavaClass());
        }
        return false;
    }

    private static void reserve(BitSet usedBytes, int offset, int size) {
        int offsetAfter = offset + size;
        assert (usedBytes.previousSetBit(offsetAfter - 1) < offset);
        usedBytes.set(offset, offsetAfter);
    }

    private static void reserveAtEnd(BitSet usedBytes, int size) {
        int endOffset = usedBytes.length();
        usedBytes.set(endOffset, endOffset + size);
    }

    private void layoutInstanceFields(HostedInstanceClass clazz, HostedField[] superFields, BitSet usedBytes) {
        ArrayList<HostedField> rawFields = new ArrayList<HostedField>();
        ArrayList<HostedField> allFields = new ArrayList<HostedField>();
        ObjectLayout layout = ConfigurationValues.getObjectLayout();
        HostedConfiguration.instance().findAllFieldsForLayout(this.hUniverse, this.hMetaAccess, this.hUniverse.fields, rawFields, allFields, clazz);
        if (UniverseBuilder.mustReserveLengthField(clazz)) {
            int lengthOffset = layout.getArrayLengthOffset();
            int lengthSize = layout.sizeInBytes(JavaKind.Int);
            UniverseBuilder.reserve(usedBytes, lengthOffset, lengthSize);
            if (clazz.equals(this.hMetaAccess.lookupJavaType((Class)DynamicHub.class))) {
                int slotsSize = this.typeCheckBuilder.getNumTypeCheckSlots() * 2;
                UniverseBuilder.reserve(usedBytes, lengthOffset + lengthSize, slotsSize);
            }
        }
        Object uncontendedSentinel = new Object();
        Object unannotatedGroup = clazz.isAnnotationPresent(Contended.class) ? new Object() : uncontendedSentinel;
        Function<HostedField, Object> getAnnotationGroup = field -> Optional.ofNullable(field.getAnnotation(Contended.class)).map(a -> "".equals(a.value()) ? new Object() : a.value()).orElse(unannotatedGroup);
        Map<Object, ArrayList> contentionGroups = rawFields.stream().sorted(HostedUniverse.FIELD_COMPARATOR_RELAXED).collect(Collectors.groupingBy(getAnnotationGroup, Collectors.toCollection(ArrayList::new)));
        ArrayList uncontendedFields = contentionGroups.remove(uncontendedSentinel);
        if (uncontendedFields != null) {
            assert (!uncontendedFields.isEmpty());
            UniverseBuilder.placeFields(uncontendedFields, usedBytes, 0, layout);
        }
        for (ArrayList groupFields : contentionGroups.values()) {
            UniverseBuilder.reserveAtEnd(usedBytes, UniverseBuilder.getContendedPadding());
            int firstOffset = usedBytes.length();
            UniverseBuilder.placeFields(groupFields, usedBytes, firstOffset, layout);
            usedBytes.set(firstOffset, usedBytes.length());
        }
        if (!contentionGroups.isEmpty()) {
            UniverseBuilder.reserveAtEnd(usedBytes, UniverseBuilder.getContendedPadding());
        }
        BitSet usedBytesInSubclasses = null;
        if (clazz.subTypes.length != 0) {
            usedBytesInSubclasses = (BitSet)usedBytes.clone();
        }
        if (clazz.needMonitorField()) {
            int endOffset;
            int size = layout.getReferenceSize();
            int offset = UniverseBuilder.findGapForField(usedBytes, 0, size, endOffset = usedBytes.length());
            if (offset == -1) {
                offset = endOffset + UniverseBuilder.getAlignmentAdjustment(endOffset, size);
            }
            UniverseBuilder.reserve(usedBytes, offset, size);
            clazz.setMonitorFieldOffset(offset);
        }
        allFields.sort(FIELD_LOCATION_COMPARATOR);
        int sizeWithoutIdHashField = usedBytes.length();
        if (!clazz.isAbstract() && !HybridLayout.isHybrid(clazz)) {
            int offset;
            if (layout.hasFixedIdentityHashField()) {
                offset = layout.getFixedIdentityHashOffset();
            } else {
                int size = 4;
                int endOffset = usedBytes.length();
                offset = UniverseBuilder.findGapForField(usedBytes, 0, size, endOffset);
                if (offset == -1) {
                    offset = endOffset + UniverseBuilder.getAlignmentAdjustment(endOffset, size);
                }
                UniverseBuilder.reserve(usedBytes, offset, size);
            }
            clazz.setOptionalIdentityHashOffset(offset);
        }
        clazz.instanceFieldsWithoutSuper = allFields.toArray(new HostedField[0]);
        clazz.afterFieldsOffset = sizeWithoutIdHashField;
        clazz.instanceSize = layout.alignUp(clazz.afterFieldsOffset);
        if (clazz.instanceFieldsWithoutSuper.length == 0) {
            clazz.instanceFieldsWithSuper = superFields;
        } else if (superFields.length == 0) {
            clazz.instanceFieldsWithSuper = clazz.instanceFieldsWithoutSuper;
        } else {
            HostedField[] instanceFieldsWithSuper = Arrays.copyOf(superFields, superFields.length + clazz.instanceFieldsWithoutSuper.length);
            System.arraycopy(clazz.instanceFieldsWithoutSuper, 0, instanceFieldsWithSuper, superFields.length, clazz.instanceFieldsWithoutSuper.length);
            Arrays.sort(instanceFieldsWithSuper, FIELD_LOCATION_COMPARATOR);
            clazz.instanceFieldsWithSuper = instanceFieldsWithSuper;
        }
        for (HostedType subClass : clazz.subTypes) {
            if (!subClass.isInstanceClass()) continue;
            this.layoutInstanceFields((HostedInstanceClass)subClass, clazz.instanceFieldsWithSuper, (BitSet)usedBytesInSubclasses.clone());
        }
    }

    private static int getContendedPadding() {
        Integer value = SubstrateOptions.ContendedPaddingWidth.getValue();
        return value > 0 ? value : 0;
    }

    private static void placeFields(ArrayList<HostedField> fields, BitSet usedBytes, int minOffset, ObjectLayout layout) {
        int lastSearchSize = -1;
        boolean lastSearchSuccess = false;
        for (HostedField field : fields) {
            int fieldSize = layout.sizeInBytes(field.getStorageKind());
            int offset = -1;
            int endOffset = usedBytes.length();
            if (lastSearchSuccess || lastSearchSize != fieldSize) {
                offset = UniverseBuilder.findGapForField(usedBytes, minOffset, fieldSize, endOffset);
                lastSearchSuccess = offset != -1;
                lastSearchSize = fieldSize;
            }
            if (offset == -1) {
                offset = endOffset + UniverseBuilder.getAlignmentAdjustment(endOffset, fieldSize);
            }
            UniverseBuilder.reserve(usedBytes, offset, fieldSize);
            field.setLocation(offset);
        }
    }

    private static int findGapForField(BitSet usedBytes, int minOffset, int fieldSize, int endOffset) {
        int candidateOffset = -1;
        int candidateSize = -1;
        int offset = usedBytes.nextClearBit(minOffset);
        while (offset < endOffset) {
            int adjustment;
            int size = usedBytes.nextSetBit(offset + 1) - offset;
            if (size >= (adjustment = UniverseBuilder.getAlignmentAdjustment(offset, fieldSize)) + fieldSize && (candidateOffset == -1 || size < candidateSize)) {
                candidateOffset = offset + adjustment;
                candidateSize = size;
            }
            offset = usedBytes.nextClearBit(offset + size);
        }
        return candidateOffset;
    }

    private static int getAlignmentAdjustment(int offset, int alignment) {
        int bits = alignment - 1;
        assert ((alignment & bits) == 0) : "expecting power of 2";
        int alignedOffset = offset + bits & ~bits;
        return alignedOffset - offset;
    }

    private void layoutStaticFields() {
        ArrayList<HostedField> fields = new ArrayList<HostedField>();
        for (HostedField field : this.hUniverse.fields.values()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            fields.add(field);
        }
        Collections.sort(fields, HostedUniverse.FIELD_COMPARATOR_RELAXED);
        ObjectLayout layout = ConfigurationValues.getObjectLayout();
        int nextPrimitiveField = 0;
        int nextObjectField = 0;
        List[] fieldsOfTypes = new ArrayList[this.hUniverse.getTypes().size()];
        for (HostedField hostedField : fields) {
            int typeId;
            if (hostedField.wrapped.isWritten() || MaterializedConstantFields.singleton().contains(hostedField.wrapped)) {
                if (hostedField.getStorageKind() == JavaKind.Object) {
                    hostedField.setLocation(NumUtil.safeToInt((long)layout.getArrayElementOffset(JavaKind.Object, nextObjectField)));
                    ++nextObjectField;
                } else {
                    int fieldSize = layout.sizeInBytes(hostedField.getStorageKind());
                    while (layout.getArrayElementOffset(JavaKind.Byte, nextPrimitiveField) % (long)fieldSize != 0L) {
                        ++nextPrimitiveField;
                    }
                    hostedField.setLocation(NumUtil.safeToInt((long)layout.getArrayElementOffset(JavaKind.Byte, nextPrimitiveField)));
                    nextPrimitiveField += fieldSize;
                }
            }
            if (fieldsOfTypes[typeId = hostedField.getDeclaringClass().getTypeID()] == null) {
                fieldsOfTypes[typeId] = new ArrayList();
            }
            fieldsOfTypes[typeId].add(hostedField);
        }
        HostedField[] noFields = new HostedField[]{};
        for (HostedType type : this.hUniverse.getTypes()) {
            List fieldsOfType = fieldsOfTypes[type.getTypeID()];
            if (fieldsOfType != null) {
                type.staticFields = fieldsOfType.toArray(new HostedField[fieldsOfType.size()]);
                continue;
            }
            type.staticFields = noFields;
        }
        Object[] objectArray = new Object[nextObjectField];
        byte[] staticPrimitiveFields = new byte[nextPrimitiveField];
        StaticFieldsSupport.setData(objectArray, staticPrimitiveFields);
    }

    private void collectDeclaredMethods() {
        ArrayList[] methodsOfType = new ArrayList[this.hUniverse.getTypes().size()];
        for (HostedMethod method : this.hUniverse.methods.values()) {
            int typeId = method.getDeclaringClass().getTypeID();
            ArrayList<HostedMethod> list = methodsOfType[typeId];
            if (list == null) {
                methodsOfType[typeId] = list = new ArrayList<HostedMethod>();
            }
            list.add(method);
        }
        for (HostedType type : this.hUniverse.getTypes()) {
            ArrayList list = methodsOfType[type.getTypeID()];
            if (list != null) {
                Collections.sort(list, HostedUniverse.METHOD_COMPARATOR);
                type.allDeclaredMethods = list.toArray(HostedMethod.EMPTY_ARRAY);
                continue;
            }
            type.allDeclaredMethods = HostedMethod.EMPTY_ARRAY;
        }
    }

    private void collectMethodImplementations() {
        for (HostedMethod method : this.hUniverse.methods.values()) {
            method.implementations = this.hUniverse.lookup((JavaMethod[])method.wrapped.getImplementations());
            Arrays.sort(method.implementations, HostedUniverse.METHOD_COMPARATOR);
        }
    }

    private void buildVTables() {
        HashMap<HostedType, ArrayList<HostedMethod>> vtablesMap = new HashMap<HostedType, ArrayList<HostedMethod>>();
        HashMap<HostedType, BitSet> usedSlotsMap = new HashMap<HostedType, BitSet>();
        HashMap<HostedMethod, Set<Integer>> vtablesSlots = new HashMap<HostedMethod, Set<Integer>>();
        for (HostedType type : this.hUniverse.getTypes()) {
            vtablesMap.put(type, new ArrayList());
            Iterator initialBitSet = new BitSet();
            usedSlotsMap.put(type, (BitSet)((Object)initialBitSet));
        }
        HostedInstanceClass objectClass = this.hUniverse.getObjectClass();
        this.assignImplementations((HostedType)objectClass, vtablesMap, usedSlotsMap, vtablesSlots);
        ArrayList<Pair> interfaces = new ArrayList<Pair>();
        for (HostedType type : this.hUniverse.getTypes()) {
            if (!type.isInterface()) continue;
            int importance = UniverseBuilder.collectSubtypes(type, new HashSet<HostedType>()).size();
            interfaces.add(Pair.create((Object)type, (Object)importance));
        }
        interfaces.sort((pair1, pair2) -> (Integer)pair2.getRight() - (Integer)pair1.getRight());
        for (Pair pair : interfaces) {
            this.assignImplementations((HostedType)pair.getLeft(), vtablesMap, usedSlotsMap, vtablesSlots);
        }
        this.buildVTable(objectClass, vtablesMap, usedSlotsMap, vtablesSlots);
        HostedMethod invalidVTableEntryHandler = this.hMetaAccess.lookupJavaMethod(InvalidMethodPointerHandler.INVALID_VTABLE_ENTRY_HANDLER_METHOD);
        for (HostedType type : this.hUniverse.getTypes()) {
            if (type.isArray()) {
                type.vtable = objectClass.vtable;
            }
            if (type.vtable == null) {
                assert (type.isInterface() || type.isPrimitive());
                type.vtable = HostedMethod.EMPTY_ARRAY;
            }
            HostedMethod[] vtableArray = type.vtable;
            for (int i = 0; i < vtableArray.length; ++i) {
                if (vtableArray[i] != null) continue;
                vtableArray[i] = invalidVTableEntryHandler;
            }
        }
        if (SubstrateUtil.assertionsEnabled()) {
            for (HostedType type : this.hUniverse.getTypes()) {
                for (HostedMethod m : type.vtable) {
                    assert (m == null || m.equals(invalidVTableEntryHandler) || m.equals(this.hUniverse.lookup((JavaMethod)type.wrapped.resolveConcreteMethod((ResolvedJavaMethod)m.wrapped, (ResolvedJavaType)type.wrapped))));
                }
            }
        }
    }

    private static Set<HostedType> collectSubtypes(HostedType type, Set<HostedType> allSubtypes) {
        if (allSubtypes.add(type)) {
            for (HostedType subtype : type.subTypes) {
                UniverseBuilder.collectSubtypes(subtype, allSubtypes);
            }
        }
        return allSubtypes;
    }

    private void buildVTable(HostedClass clazz, Map<HostedType, ArrayList<HostedMethod>> vtablesMap, Map<HostedType, BitSet> usedSlotsMap, Map<HostedMethod, Set<Integer>> vtablesSlots) {
        this.assignImplementations((HostedType)clazz, vtablesMap, usedSlotsMap, vtablesSlots);
        ArrayList<HostedMethod> vtable = vtablesMap.get(clazz);
        HostedMethod[] vtableArray = vtable.toArray(new HostedMethod[vtable.size()]);
        assert (vtableArray.length == 0 || vtableArray[vtableArray.length - 1] != null) : "Unnecessary entry at end of vtable";
        clazz.vtable = vtableArray;
        for (HostedType subClass : clazz.subTypes) {
            if (subClass.isInterface() || subClass.isArray()) continue;
            this.buildVTable((HostedClass)subClass, vtablesMap, usedSlotsMap, vtablesSlots);
        }
    }

    private void assignImplementations(HostedType type, Map<HostedType, ArrayList<HostedMethod>> vtablesMap, Map<HostedType, BitSet> usedSlotsMap, Map<HostedMethod, Set<Integer>> vtablesSlots) {
        for (HostedMethod method : type.getAllDeclaredMethods()) {
            int slot;
            if (!method.wrapped.isInvoked() && !method.wrapped.isImplementationInvoked() || method.implementations.length <= 1 && !method.wrapped.isVirtualRootMethod()) continue;
            method.vtableIndex = slot = this.findSlot(method, vtablesMap, usedSlotsMap, vtablesSlots);
            this.assignImplementations(method.getDeclaringClass(), method, slot, vtablesMap);
        }
    }

    private void assignImplementations(HostedType type, HostedMethod method, int slot, Map<HostedType, ArrayList<HostedMethod>> vtablesMap) {
        if (type.wrapped.isInstantiated()) {
            assert (type.isInstanceClass() && !type.isAbstract() || type.isArray());
            HostedMethod resolvedMethod = this.resolveMethod(type, method);
            if (resolvedMethod != null) {
                ArrayList<HostedMethod> vtable = vtablesMap.get(type);
                if (slot < vtable.size() && vtable.get(slot) != null) {
                    assert (vtable.get(slot).equals(resolvedMethod));
                } else {
                    UniverseBuilder.resize(vtable, slot + 1);
                    assert (vtable.get(slot) == null);
                    vtable.set(slot, resolvedMethod);
                }
                resolvedMethod.vtableIndex = slot;
            }
        }
        for (HostedType subtype : type.subTypes) {
            if (subtype.isArray()) continue;
            this.assignImplementations(subtype, method, slot, vtablesMap);
        }
    }

    private HostedMethod resolveMethod(HostedType type, HostedMethod method) {
        AnalysisMethod resolved = type.wrapped.resolveConcreteMethod((ResolvedJavaMethod)method.wrapped, (ResolvedJavaType)type.wrapped);
        if (resolved == null || !resolved.isImplementationInvoked()) {
            return null;
        }
        assert (!resolved.isAbstract());
        return this.hUniverse.lookup((JavaMethod)resolved);
    }

    private static void resize(ArrayList<?> list, int minSize) {
        list.ensureCapacity(minSize);
        while (list.size() < minSize) {
            list.add(null);
        }
    }

    private int findSlot(HostedMethod method, Map<HostedType, ArrayList<HostedMethod>> vtablesMap, Map<HostedType, BitSet> usedSlotsMap, Map<HostedMethod, Set<Integer>> vtablesSlots) {
        if (method.implementations.length > 0) {
            Set<Integer> resultSlots = vtablesSlots.get(method.implementations[0]);
            for (HostedMethod impl : method.implementations) {
                Set<Integer> implSlots = vtablesSlots.get(impl);
                if (implSlots == null) {
                    resultSlots = null;
                    break;
                }
                resultSlots.retainAll(implSlots);
            }
            if (resultSlots != null && !resultSlots.isEmpty()) {
                int resultSlot = Integer.MAX_VALUE;
                for (int slot : resultSlots) {
                    resultSlot = Math.min(resultSlot, slot);
                }
                return resultSlot;
            }
        }
        BitSet usedSlots = new BitSet();
        this.collectUsedSlots(method.getDeclaringClass(), usedSlots, usedSlotsMap);
        for (HostedMethod impl : method.implementations) {
            this.collectUsedSlots(impl.getDeclaringClass(), usedSlots, usedSlotsMap);
        }
        int resultSlot = usedSlots.nextClearBit(0);
        this.markSlotAsUsed(resultSlot, method.getDeclaringClass(), vtablesMap, usedSlotsMap);
        for (HostedMethod impl : method.implementations) {
            this.markSlotAsUsed(resultSlot, impl.getDeclaringClass(), vtablesMap, usedSlotsMap);
            vtablesSlots.computeIfAbsent(impl, k -> new HashSet()).add(resultSlot);
        }
        return resultSlot;
    }

    private void collectUsedSlots(HostedType type, BitSet usedSlots, Map<HostedType, BitSet> usedSlotsMap) {
        usedSlots.or(usedSlotsMap.get(type));
        for (HostedType sub : type.subTypes) {
            if (sub.isArray()) continue;
            this.collectUsedSlots(sub, usedSlots, usedSlotsMap);
        }
    }

    private void markSlotAsUsed(int resultSlot, HostedType type, Map<HostedType, ArrayList<HostedMethod>> vtablesMap, Map<HostedType, BitSet> usedSlotsMap) {
        assert (resultSlot >= vtablesMap.get(type).size() || vtablesMap.get(type).get(resultSlot) == null);
        usedSlotsMap.get(type).set(resultSlot);
        for (HostedType sub : type.subTypes) {
            if (sub.isArray()) continue;
            this.markSlotAsUsed(resultSlot, sub, vtablesMap, usedSlotsMap);
        }
    }

    private void buildHubs() {
        InstanceReferenceMapEncoder referenceMapEncoder = new InstanceReferenceMapEncoder();
        HashMap<HostedType, ReferenceMapEncoder.Input> referenceMaps = new HashMap<HostedType, ReferenceMapEncoder.Input>();
        for (HostedType type : this.hUniverse.getTypes()) {
            ReferenceMapEncoder.Input referenceMap = UniverseBuilder.createReferenceMap(type);
            assert (((SubstrateReferenceMap)referenceMap).hasNoDerivedOffsets());
            referenceMaps.put(type, referenceMap);
            referenceMapEncoder.add(referenceMap);
        }
        ((DynamicHubSupport)ImageSingletons.lookup(DynamicHubSupport.class)).setData(referenceMapEncoder.encodeAll());
        ObjectLayout ol = ConfigurationValues.getObjectLayout();
        for (HostedType type : this.hUniverse.getTypes()) {
            int layoutHelper;
            this.hUniverse.bb.getHeartbeatCallback().run();
            boolean canInstantiateAsInstance = false;
            int monitorOffset = 0;
            int optionalIdHashOffset = 0;
            if (type.isInstanceClass()) {
                HostedInstanceClass instanceClass = (HostedInstanceClass)type;
                if (instanceClass.isAbstract()) {
                    layoutHelper = LayoutEncoding.forAbstract();
                } else if (HybridLayout.isHybrid(type)) {
                    HybridLayout hybridLayout = new HybridLayout(instanceClass, ol, (MetaAccessProvider)this.hMetaAccess);
                    JavaKind storageKind = hybridLayout.getArrayElementStorageKind();
                    boolean isObject = storageKind == JavaKind.Object;
                    layoutHelper = LayoutEncoding.forHybrid(type, isObject, hybridLayout.getArrayBaseOffset(), ol.getArrayIndexShift(storageKind));
                    canInstantiateAsInstance = type.isInstantiated() && HybridLayout.canInstantiateAsInstance(type);
                } else {
                    layoutHelper = LayoutEncoding.forPureInstance(type, ConfigurationValues.getObjectLayout().alignUp(instanceClass.getInstanceSize()));
                    canInstantiateAsInstance = type.isInstantiated();
                }
                monitorOffset = instanceClass.getMonitorFieldOffset();
                optionalIdHashOffset = instanceClass.getOptionalIdentityHashOffset();
            } else if (type.isArray()) {
                JavaKind storageKind = type.getComponentType().getStorageKind();
                boolean isObject = storageKind == JavaKind.Object;
                layoutHelper = LayoutEncoding.forArray(type, isObject, ol.getArrayBaseOffset(storageKind), ol.getArrayIndexShift(storageKind));
            } else if (type.isInterface()) {
                layoutHelper = LayoutEncoding.forInterface();
            } else if (type.isPrimitive()) {
                layoutHelper = LayoutEncoding.forPrimitive();
            } else {
                throw VMError.shouldNotReachHereUnexpectedInput(type);
            }
            CFunctionPointer[] vtable = new CFunctionPointer[type.vtable.length];
            for (int idx = 0; idx < type.vtable.length; ++idx) {
                vtable[idx] = new MethodPointer(type.vtable[idx]);
            }
            ReferenceMapEncoder.Input referenceMap = (ReferenceMapEncoder.Input)referenceMaps.get(type);
            assert (referenceMap != null);
            assert (((SubstrateReferenceMap)referenceMap).hasNoDerivedOffsets());
            ReferenceMapEncoder.OffsetIterator iter = referenceMap.getOffsets();
            assert (!iter.hasNext() || iter.nextInt() >= ConfigurationValues.getObjectLayout().getFirstFieldOffset());
            long referenceMapIndex = referenceMapEncoder.lookupEncoding(referenceMap);
            boolean isProxyClass = ((DynamicProxyRegistry)ImageSingletons.lookup(DynamicProxyRegistry.class)).isProxyClass(type.getJavaClass());
            DynamicHub hub = type.getHub();
            SerializationRegistry s = (SerializationRegistry)ImageSingletons.lookup(SerializationRegistry.class);
            hub.setData(layoutHelper, type.getTypeID(), monitorOffset, optionalIdHashOffset, type.getTypeCheckStart(), type.getTypeCheckRange(), type.getTypeCheckSlot(), type.getTypeCheckSlots(), vtable, referenceMapIndex, type.isInstantiated(), canInstantiateAsInstance, isProxyClass, s.isRegisteredForSerialization(type.getJavaClass()));
        }
    }

    private static ReferenceMapEncoder.Input createReferenceMap(HostedType type) {
        HostedInstanceClass instanceClass;
        int monitorOffset;
        HostedField[] fields = type.getInstanceFields(true);
        SubstrateReferenceMap referenceMap = new SubstrateReferenceMap();
        for (HostedField field : fields) {
            if (field.getType().getStorageKind() != JavaKind.Object || !field.hasLocation() || UniverseBuilder.excludeFromReferenceMap(field)) continue;
            referenceMap.markReferenceAtOffset(field.getLocation(), true);
        }
        if (type.isInstanceClass() && (monitorOffset = (instanceClass = (HostedInstanceClass)type).getMonitorFieldOffset()) != 0) {
            referenceMap.markReferenceAtOffset(monitorOffset, true);
        }
        return referenceMap;
    }

    private static boolean excludeFromReferenceMap(HostedField field) {
        ExcludeFromReferenceMap annotation = field.getAnnotation(ExcludeFromReferenceMap.class);
        if (annotation != null) {
            return ((BooleanSupplier)ReflectionUtil.newInstance(annotation.onlyIf())).getAsBoolean();
        }
        return false;
    }

    private void processFieldLocations() {
        for (HostedField hField : this.hUniverse.fields.values()) {
            AnalysisField aField = hField.wrapped;
            if (aField.wrapped instanceof ComputedValueField) {
                ((ComputedValueField)aField.wrapped).processSubstrate(this.hMetaAccess);
            }
            if (hField.hasLocation() || !Modifier.isStatic(hField.getModifiers()) || aField.isWritten() || !aField.isValueAvailable()) continue;
            hField.setUnmaterializedStaticConstant();
        }
    }
}

