/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jni;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jni.JNIObjectFieldAccess;
import com.oracle.svm.hosted.jni.JNICallWrapperFeature;
import com.oracle.svm.hosted.jni.JNIFunctionTablesFeature;
import com.oracle.svm.hosted.jni.JNIJavaCallWrapperMethod;
import com.oracle.svm.hosted.jni.JNILibraryLoadFeature;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;

@AutomaticallyRegisteredFeature
@Platforms(value={InternalPlatform.NATIVE_ONLY.class})
public class JNIFeature
implements InternalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.JNI.getValue();
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(JNIFunctionTablesFeature.class, JNICallWrapperFeature.class, JNILibraryLoadFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        this.registerSingletons();
    }

    protected void registerSingletons() {
        ImageSingletons.add(JNIObjectFieldAccess.class, (Object)new JNIObjectFieldAccess());
        ImageSingletons.add(JNIJavaCallWrapperMethod.Factory.class, (Object)new JNIJavaCallWrapperMethod.Factory());
    }
}

